/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.impl;

import java.nio.ByteBuffer;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.codec.Data;
import org.apache.qpid.proton.codec.impl.ArrayElement;
import org.apache.qpid.proton.codec.impl.AtomicElement;
import org.apache.qpid.proton.codec.impl.Element;

class UnsignedIntegerElement
extends AtomicElement<UnsignedInteger> {
    private final UnsignedInteger _value;

    UnsignedIntegerElement(Element parent, Element prev, UnsignedInteger i) {
        super(parent, prev);
        this._value = i;
    }

    @Override
    public int size() {
        if (this.isElementOfArray()) {
            ArrayElement parent = (ArrayElement)this.parent();
            if (parent.constructorType() == ArrayElement.TINY) {
                if (this._value.intValue() == 0) {
                    return 0;
                }
                parent.setConstructorType(ArrayElement.SMALL);
            }
            if (parent.constructorType() == ArrayElement.SMALL) {
                if (0 <= this._value.intValue() && this._value.intValue() <= 255) {
                    return 1;
                }
                parent.setConstructorType(ArrayElement.LARGE);
            }
            return 4;
        }
        return 0 == this._value.intValue() ? 1 : (1 <= this._value.intValue() && this._value.intValue() <= 255 ? 2 : 5);
    }

    @Override
    public UnsignedInteger getValue() {
        return this._value;
    }

    @Override
    public Data.DataType getDataType() {
        return Data.DataType.UINT;
    }

    @Override
    public int encode(ByteBuffer b) {
        int size2 = this.size();
        if (size2 > b.remaining()) {
            return 0;
        }
        switch (size2) {
            case 1: {
                if (this.isElementOfArray()) {
                    b.put((byte)this._value.intValue());
                    break;
                }
                b.put((byte)67);
                break;
            }
            case 2: {
                b.put((byte)82);
                b.put((byte)this._value.intValue());
                break;
            }
            case 5: {
                b.put((byte)112);
            }
            case 4: {
                b.putInt(this._value.intValue());
            }
        }
        return size2;
    }
}

