/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.io.resource;

import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.linkedin.util.io.PathUtils;
import org.linkedin.util.io.resource.Resource;
import org.linkedin.util.io.resource.ResourceInfo;
import org.linkedin.util.io.resource.ResourceNotFoundException;
import org.linkedin.util.io.resource.StaticInfo;
import org.linkedin.util.io.resource.URIResourceFactory;
import org.linkedin.util.io.resource.UnsupportedURIException;
import org.linkedin.util.io.resource.internal.AbstractResource;
import org.linkedin.util.io.resource.internal.InternalResourceProvider;
import org.linkedin.util.io.resource.internal.JarResourceProvider;
import org.linkedin.util.io.resource.internal.LeafResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarResource
extends AbstractResource {
    public static final String MODULE = JarResource.class.getName();
    public static final Logger log = LoggerFactory.getLogger((String)MODULE);
    private final String _fullPath;
    private final LeafResource _jarResource;

    public JarResource(InternalResourceProvider resourceProvider, String path, LeafResource jarResource, String fullPath) {
        super(resourceProvider, path);
        this._jarResource = jarResource;
        this._fullPath = PathUtils.removeLeadingSlash(fullPath);
    }

    private JarFile getContentJarFile() throws IOException {
        return new JarFile(this._jarResource.getFile());
    }

    @Override
    public File getFile() throws IOException {
        throw new IOException("not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists() {
        boolean bl;
        if (this._fullPath.equals("")) {
            return this._jarResource.exists();
        }
        JarFile contentJarFile = this.getContentJarFile();
        try {
            JarEntry jarEntry = contentJarFile.getJarEntry(this._fullPath);
            bl = jarEntry != null;
        }
        catch (Throwable throwable) {
            try {
                contentJarFile.close();
                throw throwable;
            }
            catch (IOException e) {
                if (log.isDebugEnabled()) {
                    log.debug("exception (ignored) while getting entry " + this._fullPath, (Throwable)e);
                }
                return false;
            }
        }
        contentJarFile.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStream() throws IOException {
        JarFile contentJarFile = this.getContentJarFile();
        try {
            CloseJarFileInputStream jarFileInputStream = new CloseJarFileInputStream(this, contentJarFile, this._fullPath);
            contentJarFile = null;
            CloseJarFileInputStream closeJarFileInputStream = jarFileInputStream;
            return closeJarFileInputStream;
        }
        finally {
            if (contentJarFile != null) {
                contentJarFile.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceInfo getInfo() throws IOException {
        if (this._fullPath.equals("")) {
            return new StaticInfo(0L, this._jarResource.getInfo().getLastModified());
        }
        JarFile contentJarFile = this.getContentJarFile();
        try {
            JarEntry jarEntry = contentJarFile.getJarEntry(this._fullPath);
            if (jarEntry == null) {
                throw new ResourceNotFoundException(this.toURI());
            }
            StaticInfo staticInfo = new StaticInfo(jarEntry.getSize(), jarEntry.getTime());
            return staticInfo;
        }
        finally {
            contentJarFile.close();
        }
    }

    @Override
    public boolean isModifiedSince(long time) {
        if (this._jarResource.isModifiedSince(time)) {
            return super.isModifiedSince(time);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isDirectory() {
        if (this._fullPath.equals("")) {
            return true;
        }
        try {
            String fullPath = PathUtils.removeTrailingSlash(this._fullPath);
            JarFile contentJarFile = this.getContentJarFile();
            try {
                JarEntry directoryEntry;
                JarEntry entry = contentJarFile.getJarEntry(fullPath);
                if (entry != null && entry.getSize() == 0L && (directoryEntry = contentJarFile.getJarEntry(PathUtils.addTrailingSlash(fullPath))) != null) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                contentJarFile.close();
            }
        }
        catch (IOException e) {
            if (!log.isDebugEnabled()) return false;
            log.debug("exception (ignored) while getting entry " + this._fullPath, (Throwable)e);
            return false;
        }
    }

    @Override
    public URI toURI() {
        return this.toURI(this._fullPath);
    }

    private URI toURI(String location) {
        StringBuilder sb = new StringBuilder("jar:");
        sb.append(this._jarResource.toURI().toString());
        sb.append("!/");
        sb.append(location);
        return URI.create(sb.toString());
    }

    public static Resource create(URI uri) throws URISyntaxException, IOException {
        return JarResource.create(uri, URIResourceFactory.DEFAULT);
    }

    public static Resource create(URI uri, URIResourceFactory factory) throws URISyntaxException {
        String path = "/";
        if ("jar".equals(uri.getScheme())) {
            String schemeSpecificPart = uri.getSchemeSpecificPart();
            if (schemeSpecificPart == null) {
                throw new URISyntaxException(uri.toString(), "no scheme specific part found...");
            }
            int idx = schemeSpecificPart.indexOf("!/");
            if (idx == -1) {
                throw new URISyntaxException(uri.toString(), "couldn't find !/");
            }
            uri = new URI(schemeSpecificPart.substring(0, idx));
            path = schemeSpecificPart.substring(idx + 1);
        }
        try {
            JarResourceProvider provider = new JarResourceProvider(factory.createResource(uri));
            return provider.createResource("/").createRelative(path);
        }
        catch (UnsupportedURIException e) {
            URISyntaxException ex = new URISyntaxException(uri.toString(), "cannot create resource");
            ex.initCause(e);
            throw ex;
        }
    }

    public static Resource create(Resource jarResource) {
        return JarResource.create(jarResource, "/");
    }

    public static Resource create(Resource jarResource, String rootPath) {
        return new JarResourceProvider(jarResource, rootPath).getRootResource();
    }

    private static class CloseJarFileInputStream
    extends FilterInputStream {
        private final JarFile _jarFile;

        public CloseJarFileInputStream(Resource resource, JarFile jarFile, String location) throws IOException {
            super(CloseJarFileInputStream.extractInputStream(jarFile, location, resource));
            this._jarFile = jarFile;
        }

        private static InputStream extractInputStream(JarFile jarFile, String location, Resource resource) throws IOException {
            JarEntry directoryEntry;
            JarEntry jarEntry = jarFile.getJarEntry(location);
            if (jarEntry == null) {
                throw new IOException("cannot get input stream for entry " + location + " for " + resource.toURI());
            }
            if (jarEntry.getSize() == 0L && (directoryEntry = jarFile.getJarEntry(PathUtils.addTrailingSlash(location))) != null) {
                throw new IOException("cannot read directory for " + resource.toURI());
            }
            InputStream is = jarFile.getInputStream(jarEntry);
            if (is == null) {
                throw new IOException("cannot get input stream for entry " + jarEntry + " for " + resource.toURI());
            }
            return is;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                this._jarFile.close();
            }
        }
    }
}

