/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.plugin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import javax.management.JMException;
import javax.management.ObjectName;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerContext;
import org.apache.activemq.broker.BrokerFilter;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.plugin.ConfigurationProcessor;
import org.apache.activemq.plugin.ProcessorFactory;
import org.apache.activemq.plugin.PropertiesPlaceHolderUtil;
import org.apache.activemq.plugin.jmx.RuntimeConfigurationView;
import org.apache.activemq.schema.core.DtoBroker;
import org.apache.activemq.spring.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class RuntimeConfigurationBroker
extends BrokerFilter {
    public static final Logger LOG = LoggerFactory.getLogger(RuntimeConfigurationBroker.class);
    public static final String objectNamePropsAppendage = ",service=RuntimeConfiguration,name=Plugin";
    private final ReentrantReadWriteLock addDestinationBarrier = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock addConnectionBarrier = new ReentrantReadWriteLock();
    PropertiesPlaceHolderUtil placeHolderUtil = null;
    private long checkPeriod;
    private long lastModified = -1L;
    private Resource configToMonitor;
    private DtoBroker currentConfiguration;
    private Runnable monitorTask;
    protected ConcurrentLinkedQueue<Runnable> addDestinationWork = new ConcurrentLinkedQueue();
    protected ConcurrentLinkedQueue<Runnable> addConnectionWork = new ConcurrentLinkedQueue();
    private ObjectName objectName;
    private String infoString;
    private Schema schema;
    Pattern matchPassword = Pattern.compile("password=.*,");

    public RuntimeConfigurationBroker(Broker next) {
        super(next);
    }

    @Override
    public void start() throws Exception {
        super.start();
        try {
            BrokerContext brokerContext = this.next.getBrokerService().getBrokerContext();
            if (brokerContext != null) {
                this.configToMonitor = Utils.resourceFromString(brokerContext.getConfigurationUrl());
                this.info("Configuration " + this.configToMonitor);
            } else {
                LOG.error("Null BrokerContext; impossible to determine configuration url resource from broker, updates cannot be tracked");
            }
        }
        catch (Exception error) {
            LOG.error("failed to determine configuration url resource from broker, updates cannot be tracked", (Throwable)error);
        }
        this.currentConfiguration = this.loadConfiguration(this.configToMonitor);
        this.monitorModification(this.configToMonitor);
        this.registerMbean();
    }

    @Override
    public void stop() throws Exception {
        if (this.monitorTask != null) {
            try {
                this.getBrokerService().getScheduler().cancel(this.monitorTask);
            }
            catch (Exception letsNotStopStop) {
                LOG.warn("Failed to cancel config monitor task", (Throwable)letsNotStopStop);
            }
        }
        this.unregisterMbean();
        super.stop();
    }

    private void registerMbean() {
        if (this.getBrokerService().isUseJmx()) {
            ManagementContext managementContext = this.getBrokerService().getManagementContext();
            try {
                this.objectName = new ObjectName(this.getBrokerService().getBrokerObjectName().toString() + objectNamePropsAppendage);
                managementContext.registerMBean(new RuntimeConfigurationView(this), this.objectName);
            }
            catch (Exception ignored) {
                LOG.debug("failed to register RuntimeConfigurationMBean", (Throwable)ignored);
            }
        }
    }

    private void unregisterMbean() {
        if (this.objectName != null) {
            try {
                this.getBrokerService().getManagementContext().unregisterMBean(this.objectName);
            }
            catch (JMException jMException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Destination addDestination(ConnectionContext context, ActiveMQDestination destination, boolean createIfTemporary) throws Exception {
        Runnable work = this.addDestinationWork.poll();
        if (work != null) {
            try {
                this.addDestinationBarrier.writeLock().lockInterruptibly();
                do {
                    work.run();
                } while ((work = this.addDestinationWork.poll()) != null);
                Destination destination2 = super.addDestination(context, destination, createIfTemporary);
                return destination2;
            }
            finally {
                this.addDestinationBarrier.writeLock().unlock();
            }
        }
        try {
            this.addDestinationBarrier.readLock().lockInterruptibly();
            Destination destination3 = super.addDestination(context, destination, createIfTemporary);
            return destination3;
        }
        finally {
            this.addDestinationBarrier.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnection(ConnectionContext context, ConnectionInfo info) throws Exception {
        Runnable work = this.addConnectionWork.poll();
        if (work != null) {
            try {
                this.addConnectionBarrier.writeLock().lockInterruptibly();
                do {
                    work.run();
                } while ((work = this.addConnectionWork.poll()) != null);
                super.addConnection(context, info);
            }
            finally {
                this.addConnectionBarrier.writeLock().unlock();
            }
        }
        try {
            this.addConnectionBarrier.readLock().lockInterruptibly();
            super.addConnection(context, info);
        }
        finally {
            this.addConnectionBarrier.readLock().unlock();
        }
    }

    public String updateNow() {
        LOG.info("Manual configuration update triggered");
        this.infoString = "";
        this.applyModifications(this.configToMonitor);
        String result = this.infoString;
        this.infoString = null;
        return result;
    }

    private void monitorModification(final Resource configToMonitor) {
        this.monitorTask = new Runnable(){

            @Override
            public void run() {
                try {
                    if (configToMonitor.lastModified() > RuntimeConfigurationBroker.this.lastModified) {
                        RuntimeConfigurationBroker.this.applyModifications(configToMonitor);
                    }
                }
                catch (Throwable e) {
                    LOG.error("Failed to determine lastModified time on configuration: " + configToMonitor, e);
                }
            }
        };
        if (this.lastModified > 0L && this.checkPeriod > 0L) {
            this.getBrokerService().getScheduler().executePeriodically(this.monitorTask, this.checkPeriod);
            this.info("Monitoring for updates (every " + this.checkPeriod + "millis) : " + configToMonitor + ", lastUpdate: " + new Date(this.lastModified));
        }
    }

    protected void debug(String s) {
        LOG.debug(s);
    }

    protected void info(String s) {
        LOG.info(this.filterPasswords(s));
        if (this.infoString != null) {
            this.infoString = this.infoString + s;
            this.infoString = this.infoString + ";";
        }
    }

    protected void info(String s, Throwable t) {
        LOG.info(this.filterPasswords(s), t);
        if (this.infoString != null) {
            this.infoString = this.infoString + s;
            this.infoString = this.infoString + ", " + t;
            this.infoString = this.infoString + ";";
        }
    }

    private void applyModifications(Resource configToMonitor) {
        DtoBroker changed2 = this.loadConfiguration(configToMonitor);
        if (changed2 != null && !this.currentConfiguration.equals(changed2)) {
            LOG.info("change in " + configToMonitor + " at: " + new Date(this.lastModified));
            LOG.debug("current:" + this.filterPasswords(this.currentConfiguration));
            LOG.debug("new    :" + this.filterPasswords(changed2));
            this.processSelectiveChanges(this.currentConfiguration, changed2);
            this.currentConfiguration = changed2;
        } else {
            this.info("No material change to configuration in " + configToMonitor + " at: " + new Date(this.lastModified));
        }
    }

    private void processSelectiveChanges(DtoBroker currentConfiguration, DtoBroker modifiedConfiguration) {
        for (Class upDatable : new Class[]{DtoBroker.DestinationPolicy.class, DtoBroker.NetworkConnectors.class, DtoBroker.DestinationInterceptors.class, DtoBroker.Plugins.class, DtoBroker.Destinations.class}) {
            this.processChanges(currentConfiguration, modifiedConfiguration, upDatable);
        }
    }

    private void processChanges(DtoBroker currentConfiguration, DtoBroker modifiedConfiguration, Class upDatable) {
        ConfigurationProcessor processor = ProcessorFactory.createProcessor(this, upDatable);
        processor.processChanges(currentConfiguration, modifiedConfiguration);
    }

    private String filterPasswords(Object toEscape) {
        return this.matchPassword.matcher(toEscape.toString()).replaceAll("password=???,");
    }

    private DtoBroker loadConfiguration(Resource configToMonitor) {
        DtoBroker jaxbConfig = null;
        if (configToMonitor != null) {
            try {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{DtoBroker.class});
                Unmarshaller unMarshaller = context.createUnmarshaller();
                unMarshaller.setSchema(this.getSchema());
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(configToMonitor.getInputStream());
                Node brokerRootNode = doc.getElementsByTagNameNS("*", "broker").item(0);
                if (brokerRootNode != null) {
                    JAXBElement brokerJAXBElement = unMarshaller.unmarshal(brokerRootNode, DtoBroker.class);
                    jaxbConfig = (DtoBroker)brokerJAXBElement.getValue();
                    this.lastModified = configToMonitor.lastModified();
                    this.loadPropertiesPlaceHolderSupport(doc);
                } else {
                    this.info("Failed to find 'broker' element by tag in: " + configToMonitor);
                }
            }
            catch (IOException e) {
                this.info("Failed to access: " + configToMonitor, e);
            }
            catch (JAXBException e) {
                this.info("Failed to parse: " + configToMonitor, e);
            }
            catch (ParserConfigurationException e) {
                this.info("Failed to document parse: " + configToMonitor, e);
            }
            catch (SAXException e) {
                this.info("Failed to find broker element in: " + configToMonitor, e);
            }
            catch (Exception e) {
                this.info("Unexpected exception during load of: " + configToMonitor, e);
            }
        }
        return jaxbConfig;
    }

    private void loadPropertiesPlaceHolderSupport(Document doc) {
        BrokerContext brokerContext = this.getBrokerService().getBrokerContext();
        if (brokerContext != null) {
            Properties initialProperties = new Properties(System.getProperties());
            this.placeHolderUtil = new PropertiesPlaceHolderUtil(initialProperties);
            this.placeHolderUtil.mergeProperties(doc, initialProperties, brokerContext);
        }
    }

    private Schema getSchema() throws SAXException, IOException {
        if (this.schema == null) {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            ArrayList<StreamSource> schemas = new ArrayList<StreamSource>();
            schemas.add(new StreamSource(this.getClass().getResource("/activemq.xsd").toExternalForm()));
            schemas.add(new StreamSource(this.getClass().getResource("/org/springframework/beans/factory/xml/spring-beans-3.0.xsd").toExternalForm()));
            this.schema = schemaFactory.newSchema(schemas.toArray(new Source[0]));
        }
        return this.schema;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public Resource getConfigToMonitor() {
        return this.configToMonitor;
    }

    public long getCheckPeriod() {
        return this.checkPeriod;
    }

    public void setCheckPeriod(long checkPeriod) {
        this.checkPeriod = checkPeriod;
    }
}

