/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.plugin;

import java.util.Iterator;
import java.util.Set;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.DestinationFilter;
import org.apache.activemq.broker.region.Queue;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.broker.region.Topic;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.plugin.DefaultConfigurationProcessor;
import org.apache.activemq.plugin.RuntimeConfigurationBroker;

public class PolicyEntryProcessor
extends DefaultConfigurationProcessor {
    public PolicyEntryProcessor(RuntimeConfigurationBroker plugin, Class configurationClass) {
        super(plugin, configurationClass);
    }

    @Override
    public void addNew(Object o) {
        PolicyEntry addition = this.fromDto(o, new PolicyEntry());
        PolicyMap existingMap = this.plugin.getBrokerService().getDestinationPolicy();
        existingMap.put(addition.getDestination(), addition);
        this.applyRetrospectively(addition);
        this.plugin.info("added policy for: " + addition.getDestination());
    }

    @Override
    public void modify(Object existing, Object candidate) {
        PolicyEntry updatedEntry;
        PolicyMap existingMap = this.plugin.getBrokerService().getDestinationPolicy();
        Set existingEntry = existingMap.get((updatedEntry = this.fromDto(candidate, new PolicyEntry())).getDestination());
        if (existingEntry.size() == 1) {
            updatedEntry = this.fromDto(candidate, (PolicyEntry)existingEntry.iterator().next());
            this.applyRetrospectively(updatedEntry);
            this.plugin.info("updated policy for: " + updatedEntry.getDestination());
        } else {
            this.plugin.info("cannot modify policy matching multiple destinations: " + existingEntry + ", destination:" + updatedEntry.getDestination());
        }
    }

    protected void applyRetrospectively(PolicyEntry updatedEntry) {
        RegionBroker regionBroker = (RegionBroker)this.plugin.getBrokerService().getRegionBroker();
        Iterator<Destination> i$ = regionBroker.getDestinations(updatedEntry.getDestination()).iterator();
        while (i$.hasNext()) {
            Destination destination;
            Destination target = destination = i$.next();
            if (destination instanceof DestinationFilter) {
                target = ((DestinationFilter)destination).getNext();
            }
            if (target.getActiveMQDestination().isQueue()) {
                updatedEntry.update((Queue)target);
            } else if (target.getActiveMQDestination().isTopic()) {
                updatedEntry.update((Topic)target);
            }
            this.plugin.debug("applied update to:" + target);
        }
    }
}

