/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.io.resource.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.linkedin.util.io.GCFile;
import org.linkedin.util.io.IOUtils;
import org.linkedin.util.io.resource.Resource;
import org.linkedin.util.io.resource.ResourceInfo;
import org.linkedin.util.io.resource.StaticInfo;
import org.linkedin.util.io.resource.internal.LeafResource;
import org.linkedin.util.io.resource.internal.LeafResourceImpl;

public class LocalCacheLeafResource
implements LeafResource {
    private final Resource _resource;
    private File _localFile = null;
    private StaticInfo _resourceInfo = null;
    private IOException _ioException = null;

    public LocalCacheLeafResource(Resource resource) {
        this._resource = resource;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.getFile());
    }

    @Override
    public boolean exists() {
        this.init();
        return this._resourceInfo.getLastModified() > 0L;
    }

    @Override
    public File getFile() throws IOException {
        this.init();
        if (this._ioException != null) {
            throw this._ioException;
        }
        return this._localFile;
    }

    @Override
    public ResourceInfo getInfo() throws IOException {
        this.init();
        if (this._ioException != null) {
            throw this._ioException;
        }
        return this._resourceInfo;
    }

    @Override
    public long lastModified() {
        this.init();
        return this._resourceInfo.getLastModified();
    }

    @Override
    public boolean isModifiedSince(long time) {
        return this.lastModified() > time;
    }

    @Override
    public long length() {
        this.init();
        return this._resourceInfo.getContentLength();
    }

    @Override
    public URI toURI() {
        return this._resource.toURI();
    }

    @Override
    public String getFilename() {
        return this._resource.getFilename();
    }

    @Override
    public String getPath() {
        return this._resource.getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void init() {
        if (this._resourceInfo != null) {
            return;
        }
        try {
            InputStream is = this._resource.getInputStream();
            try {
                GCFile file = GCFile.createTempFile(LocalCacheLeafResource.class.getName(), this._resource.getFilename());
                FileOutputStream fos = new FileOutputStream(file);
                try {
                    BufferedOutputStream out = new BufferedOutputStream(fos);
                    IOUtils.copy(new BufferedInputStream(is), out);
                    out.flush();
                }
                finally {
                    fos.close();
                }
                ResourceInfo info = this._resource.getInfo();
                this._localFile = file;
                this._resourceInfo = new StaticInfo(info.getContentLength(), info.getLastModified());
                this._ioException = null;
            }
            finally {
                is.close();
            }
        }
        catch (IOException e) {
            this._localFile = null;
            this._resourceInfo = new StaticInfo(0L, 0L);
            this._ioException = e;
        }
    }

    public static LeafResource create(Resource resource) {
        try {
            resource.getFile();
            return new LeafResourceImpl(resource);
        }
        catch (IOException e) {
            return new LocalCacheLeafResource(resource);
        }
    }
}

