/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.io.resource;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.linkedin.util.io.ram.RAMDirectory;
import org.linkedin.util.io.ram.RAMEntry;
import org.linkedin.util.io.ram.RAMFile;
import org.linkedin.util.io.resource.Resource;
import org.linkedin.util.io.resource.ResourceInfo;
import org.linkedin.util.io.resource.ResourceNotFoundException;
import org.linkedin.util.io.resource.StaticInfo;
import org.linkedin.util.io.resource.internal.AbstractResource;
import org.linkedin.util.io.resource.internal.RAMResourceProvider;

public class RAMResource
extends AbstractResource {
    private final String _fullPath;
    private final RAMResourceProvider _resourceProvider;

    public RAMResource(RAMResourceProvider resourceProvider, String fullPath, String path) {
        super(resourceProvider, path);
        this._resourceProvider = resourceProvider;
        this._fullPath = fullPath;
    }

    public RAMEntry getRAMEntry() {
        return this._resourceProvider.getRAMEntry(this._fullPath);
    }

    @Override
    public boolean exists() {
        return this.getRAMEntry() != null;
    }

    @Override
    public File getFile() throws IOException {
        throw new IOException("not a file");
    }

    @Override
    public InputStream getInputStream() throws IOException {
        RAMEntry entry = this.getRAMEntry();
        if (entry == null || entry instanceof RAMDirectory) {
            throw new ResourceNotFoundException(this.toURI());
        }
        return new ByteArrayInputStream(((RAMFile)entry).getContent());
    }

    @Override
    public ResourceInfo getInfo() throws IOException {
        RAMEntry entry = this.getRAMEntry();
        if (entry != null) {
            return new StaticInfo(entry.getContentLength(), entry.lastModified());
        }
        throw new ResourceNotFoundException(this.toURI());
    }

    @Override
    public boolean isDirectory() {
        return this.getRAMEntry() instanceof RAMDirectory;
    }

    @Override
    public URI toURI() {
        try {
            return new URI("ram://" + this._fullPath);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static Resource create(RAMDirectory root) {
        return new RAMResourceProvider(root).getRootResource();
    }
}

