/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.internal;

import java.util.LinkedList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import org.fusesource.hawtdispatch.DispatchPriority;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.Metrics;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.hawtdispatch.TaskWrapper;
import org.fusesource.hawtdispatch.internal.GlobalDispatchQueue;
import org.fusesource.hawtdispatch.internal.HawtDispatchQueue;
import org.fusesource.hawtdispatch.internal.HawtDispatcher;
import org.fusesource.hawtdispatch.internal.SerialDispatchQueue;
import org.fusesource.hawtdispatch.internal.WorkerThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ThreadDispatchQueue
implements HawtDispatchQueue {
    volatile String label;
    final LinkedList<Task> localTasks = new LinkedList();
    final ConcurrentLinkedQueue<Task> sharedTasks = new ConcurrentLinkedQueue();
    final WorkerThread thread;
    final GlobalDispatchQueue globalQueue;
    private final LinkedList<Task> sourceQueue = new LinkedList();

    public ThreadDispatchQueue(GlobalDispatchQueue globalQueue, WorkerThread thread) {
        this.thread = thread;
        this.globalQueue = globalQueue;
        this.label = thread.getName() + " pritority: " + globalQueue.getLabel();
        this.getDispatcher().track(this);
    }

    @Override
    public LinkedList<Task> getSourceQueue() {
        return this.sourceQueue;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public boolean isExecuting() {
        return this.globalQueue.dispatcher.getCurrentThreadQueue() == this;
    }

    @Override
    public void assertExecuting() {
        assert (this.isExecuting()) : this.getDispatcher().assertMessage(this.getLabel());
    }

    @Override
    public HawtDispatcher getDispatcher() {
        return this.globalQueue.dispatcher;
    }

    @Override
    @Deprecated
    public void execute(Runnable runnable) {
        this.execute(new TaskWrapper(runnable));
    }

    @Override
    @Deprecated
    public void executeAfter(long delay, TimeUnit unit, Runnable runnable) {
        this.executeAfter(delay, unit, new TaskWrapper(runnable));
    }

    @Override
    public void execute(Task task2) {
        if (Thread.currentThread() != this.thread) {
            this.sharedTasks.add(task2);
            this.thread.unpark();
        } else {
            this.localTasks.add(task2);
        }
    }

    public Task poll() {
        Task rc = this.localTasks.poll();
        if (rc == null) {
            rc = this.sharedTasks.poll();
        }
        return rc;
    }

    @Override
    public void executeAfter(long delay, TimeUnit unit, Task task2) {
        this.getDispatcher().timerThread.addRelative(task2, this, delay, unit);
    }

    @Override
    public void resume() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void suspend() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSuspended() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTargetQueue(DispatchQueue queue2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HawtDispatchQueue getTargetQueue() {
        return null;
    }

    public DispatchPriority getPriority() {
        return this.globalQueue.getPriority();
    }

    @Override
    public GlobalDispatchQueue isGlobalDispatchQueue() {
        return null;
    }

    @Override
    public SerialDispatchQueue isSerialDispatchQueue() {
        return null;
    }

    @Override
    public ThreadDispatchQueue isThreadDispatchQueue() {
        return this;
    }

    @Override
    public DispatchQueue createQueue(String label) {
        SerialDispatchQueue rc = this.globalQueue.dispatcher.createQueue(label);
        rc.setTargetQueue(this);
        return rc;
    }

    @Override
    public DispatchQueue.QueueType getQueueType() {
        return DispatchQueue.QueueType.THREAD_QUEUE;
    }

    @Override
    public void profile(boolean on) {
    }

    @Override
    public boolean profile() {
        return false;
    }

    @Override
    public Metrics metrics() {
        return null;
    }

    public WorkerThread getThread() {
        return this.thread;
    }
}

