/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.filter;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.filter.DestinationMapEntry;
import org.apache.activemq.filter.DestinationMapNode;
import org.apache.activemq.filter.DestinationNode;

public class DestinationMap {
    protected static final String ANY_DESCENDENT = ">";
    protected static final String ANY_CHILD = "*";
    private DestinationMapNode queueRootNode = new DestinationMapNode(null);
    private DestinationMapNode tempQueueRootNode = new DestinationMapNode(null);
    private DestinationMapNode topicRootNode = new DestinationMapNode(null);
    private DestinationMapNode tempTopicRootNode = new DestinationMapNode(null);

    public synchronized Set get(ActiveMQDestination key) {
        if (key.isComposite()) {
            ActiveMQDestination[] destinations = key.getCompositeDestinations();
            HashSet<Set> answer = new HashSet<Set>(destinations.length);
            for (int i = 0; i < destinations.length; ++i) {
                ActiveMQDestination childDestination = destinations[i];
                Set value = this.get(childDestination);
                if (value instanceof Set) {
                    answer.addAll(value);
                    continue;
                }
                if (value == null) continue;
                answer.add(value);
            }
            return answer;
        }
        return this.findWildcardMatches(key);
    }

    public synchronized void put(ActiveMQDestination key, Object value) {
        if (key.isComposite()) {
            ActiveMQDestination[] destinations = key.getCompositeDestinations();
            for (int i = 0; i < destinations.length; ++i) {
                ActiveMQDestination childDestination = destinations[i];
                this.put(childDestination, value);
            }
            return;
        }
        String[] paths = key.getDestinationPaths();
        this.getRootNode(key).add(paths, 0, value);
    }

    public synchronized void remove(ActiveMQDestination key, Object value) {
        if (key.isComposite()) {
            ActiveMQDestination[] destinations = key.getCompositeDestinations();
            for (int i = 0; i < destinations.length; ++i) {
                ActiveMQDestination childDestination = destinations[i];
                this.remove(childDestination, value);
            }
            return;
        }
        String[] paths = key.getDestinationPaths();
        this.getRootNode(key).remove(paths, 0, value);
    }

    public int getTopicRootChildCount() {
        return this.topicRootNode.getChildCount();
    }

    public int getQueueRootChildCount() {
        return this.queueRootNode.getChildCount();
    }

    public DestinationMapNode getQueueRootNode() {
        return this.queueRootNode;
    }

    public DestinationMapNode getTopicRootNode() {
        return this.topicRootNode;
    }

    public DestinationMapNode getTempQueueRootNode() {
        return this.tempQueueRootNode;
    }

    public DestinationMapNode getTempTopicRootNode() {
        return this.tempTopicRootNode;
    }

    protected void setEntries(List<DestinationMapEntry> entries) {
        for (DestinationMapEntry element : entries) {
            Class<? extends DestinationMapEntry> type = this.getEntryClass();
            if (type.isInstance(element)) {
                DestinationMapEntry entry = element;
                this.put(entry.getDestination(), entry.getValue());
                continue;
            }
            throw new IllegalArgumentException("Each entry must be an instance of type: " + type.getName() + " but was: " + element);
        }
    }

    protected Class<? extends DestinationMapEntry> getEntryClass() {
        return DestinationMapEntry.class;
    }

    protected Set findWildcardMatches(ActiveMQDestination key) {
        String[] paths = key.getDestinationPaths();
        HashSet<DestinationNode> answer = new HashSet<DestinationNode>();
        this.getRootNode(key).appendMatchingValues(answer, paths, 0);
        return answer;
    }

    public Set removeAll(ActiveMQDestination key) {
        HashSet<DestinationNode> rc = new HashSet<DestinationNode>();
        if (key.isComposite()) {
            ActiveMQDestination[] destinations = key.getCompositeDestinations();
            for (int i = 0; i < destinations.length; ++i) {
                rc.add((DestinationNode)((Object)this.removeAll(destinations[i])));
            }
            return rc;
        }
        String[] paths = key.getDestinationPaths();
        this.getRootNode(key).removeAll(rc, paths, 0);
        return rc;
    }

    public Object chooseValue(ActiveMQDestination destination) {
        Set set2 = this.get(destination);
        if (set2 == null || set2.isEmpty()) {
            return null;
        }
        TreeSet sortedSet = new TreeSet(set2);
        return sortedSet.last();
    }

    protected DestinationMapNode getRootNode(ActiveMQDestination key) {
        if (key.isTemporary()) {
            if (key.isQueue()) {
                return this.tempQueueRootNode;
            }
            return this.tempTopicRootNode;
        }
        if (key.isQueue()) {
            return this.queueRootNode;
        }
        return this.topicRootNode;
    }

    public void reset() {
        this.queueRootNode = new DestinationMapNode(null);
        this.tempQueueRootNode = new DestinationMapNode(null);
        this.topicRootNode = new DestinationMapNode(null);
        this.tempTopicRootNode = new DestinationMapNode(null);
    }

    public boolean isEmpty() {
        return this.queueRootNode.isEmpty() && this.topicRootNode.isEmpty() && this.tempQueueRootNode.isEmpty() && this.tempTopicRootNode.isEmpty();
    }

    public static Set union(Set existing, Set candidates) {
        if (candidates != null) {
            if (existing != null) {
                Iterator iterator = existing.iterator();
                while (iterator.hasNext()) {
                    Object toMatch = iterator.next();
                    if (candidates.contains(toMatch)) continue;
                    iterator.remove();
                }
            } else {
                existing = candidates;
            }
        } else if (existing != null) {
            existing.clear();
        }
        return existing;
    }
}

