/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import java.util.Arrays;
import java.util.Collection;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.codec.AbstractPrimitiveType;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.FixedSizePrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.PrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.TypeEncoding;

public class UnsignedLongType
extends AbstractPrimitiveType<UnsignedLong> {
    private UnsignedLongEncoding _unsignedLongEncoding;
    private UnsignedLongEncoding _smallUnsignedLongEncoding;
    private UnsignedLongEncoding _zeroUnsignedLongEncoding;

    UnsignedLongType(EncoderImpl encoder, DecoderImpl decoder) {
        this._unsignedLongEncoding = new AllUnsignedLongEncoding(encoder, decoder);
        this._smallUnsignedLongEncoding = new SmallUnsignedLongEncoding(encoder, decoder);
        this._zeroUnsignedLongEncoding = new ZeroUnsignedLongEncoding(encoder, decoder);
        encoder.register(UnsignedLong.class, this);
        decoder.register(this);
    }

    @Override
    public Class<UnsignedLong> getTypeClass() {
        return UnsignedLong.class;
    }

    public UnsignedLongEncoding getEncoding(UnsignedLong val) {
        long l = val.longValue();
        return l == 0L ? this._zeroUnsignedLongEncoding : (l >= 0L && l <= 255L ? this._smallUnsignedLongEncoding : this._unsignedLongEncoding);
    }

    public UnsignedLongEncoding getCanonicalEncoding() {
        return this._unsignedLongEncoding;
    }

    @Override
    public Collection<UnsignedLongEncoding> getAllEncodings() {
        return Arrays.asList(this._zeroUnsignedLongEncoding, this._smallUnsignedLongEncoding, this._unsignedLongEncoding);
    }

    private class ZeroUnsignedLongEncoding
    extends FixedSizePrimitiveTypeEncoding<UnsignedLong>
    implements UnsignedLongEncoding {
        public ZeroUnsignedLongEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        public byte getEncodingCode() {
            return 68;
        }

        @Override
        protected int getFixedSize() {
            return 0;
        }

        public UnsignedLongType getType() {
            return UnsignedLongType.this;
        }

        @Override
        public void writeValue(UnsignedLong val) {
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<UnsignedLong> encoder) {
            return encoder == this;
        }

        @Override
        public UnsignedLong readValue() {
            return UnsignedLong.ZERO;
        }
    }

    private class SmallUnsignedLongEncoding
    extends FixedSizePrimitiveTypeEncoding<UnsignedLong>
    implements UnsignedLongEncoding {
        public SmallUnsignedLongEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        public byte getEncodingCode() {
            return 83;
        }

        @Override
        protected int getFixedSize() {
            return 1;
        }

        public UnsignedLongType getType() {
            return UnsignedLongType.this;
        }

        @Override
        public void writeValue(UnsignedLong val) {
            this.getEncoder().writeRaw((byte)val.longValue());
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<UnsignedLong> encoder) {
            return encoder == this || encoder instanceof ZeroUnsignedLongEncoding;
        }

        @Override
        public UnsignedLong readValue() {
            return UnsignedLong.valueOf((long)this.getDecoder().readRawByte() & 0xFFL);
        }
    }

    private class AllUnsignedLongEncoding
    extends FixedSizePrimitiveTypeEncoding<UnsignedLong>
    implements UnsignedLongEncoding {
        public AllUnsignedLongEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        protected int getFixedSize() {
            return 8;
        }

        @Override
        public byte getEncodingCode() {
            return -128;
        }

        public UnsignedLongType getType() {
            return UnsignedLongType.this;
        }

        @Override
        public void writeValue(UnsignedLong val) {
            this.getEncoder().writeRaw(val.longValue());
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<UnsignedLong> encoding) {
            return this.getType() == encoding.getType();
        }

        @Override
        public UnsignedLong readValue() {
            return UnsignedLong.valueOf(this.getDecoder().readRawLong());
        }
    }

    public static interface UnsignedLongEncoding
    extends PrimitiveTypeEncoding<UnsignedLong> {
    }
}

