/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jaas;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;

class PrincipalProperties {
    private final Properties principals;
    private final long reloadTime;

    PrincipalProperties(String type, File source, Logger log) {
        Properties props = new Properties();
        long reloadTime = 0L;
        try {
            this.load(source, props);
            reloadTime = System.currentTimeMillis();
        }
        catch (IOException ioe) {
            log.warn("Unable to load " + type + " properties file " + source);
        }
        this.reloadTime = reloadTime;
        this.principals = props;
    }

    Set<Map.Entry<String, String>> entries() {
        return this.principals.entrySet();
    }

    String getProperty(String name) {
        return this.principals.getProperty(name);
    }

    long getReloadTime() {
        return this.reloadTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(File source, Properties props) throws FileNotFoundException, IOException {
        FileInputStream in = new FileInputStream(source);
        try {
            props.load(in);
        }
        finally {
            in.close();
        }
    }
}

