/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jaas;

import java.util.ArrayList;
import java.util.Properties;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.encryption.pbe.config.EnvironmentStringPBEConfig;
import org.jasypt.encryption.pbe.config.PBEConfig;
import org.jasypt.iv.IvGenerator;
import org.jasypt.iv.RandomIvGenerator;
import org.jasypt.properties.PropertyValueEncryptionUtils;

public class EncryptionSupport {
    public static void decrypt(Properties props, String algorithm) {
        StandardPBEStringEncryptor encryptor = EncryptionSupport.createEncryptor(algorithm);
        for (Object k : new ArrayList<Object>(props.keySet())) {
            String key = (String)k;
            String value = props.getProperty(key);
            if (!PropertyValueEncryptionUtils.isEncryptedValue((String)value)) continue;
            value = PropertyValueEncryptionUtils.decrypt((String)value, (StringEncryptor)encryptor);
            props.setProperty(key, value);
        }
    }

    public static StandardPBEStringEncryptor createEncryptor(String algorithm) {
        StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
        EnvironmentStringPBEConfig config = new EnvironmentStringPBEConfig();
        if (algorithm != null) {
            encryptor.setAlgorithm(algorithm);
            if (algorithm.startsWith("PBE") && algorithm.contains("AES")) {
                encryptor.setIvGenerator((IvGenerator)new RandomIvGenerator());
            }
        }
        config.setPasswordEnvName("ACTIVEMQ_ENCRYPTION_PASSWORD");
        encryptor.setConfig((PBEConfig)config);
        return encryptor;
    }
}

