/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import org.apache.activemq.util.DataByteArrayInputStream;
import org.apache.activemq.util.DataByteArrayOutputStream;
import org.junit.Assert;
import org.junit.Test;

public class DataByteArrayInputStreamTest {
    @Test
    public void testNonAscii() throws Exception {
        char t;
        this.doMarshallUnMarshallValidation("mei\u00dfen");
        Object accumulator = new String();
        int test = 0;
        while (Character.isDefined(test)) {
            String toTest = String.valueOf((char)test);
            accumulator = (String)accumulator + toTest;
            this.doMarshallUnMarshallValidation(toTest);
            ++test;
        }
        int massiveThreeByteCharValue = 4095;
        String toTest = String.valueOf((char)massiveThreeByteCharValue);
        accumulator = (String)accumulator + toTest;
        this.doMarshallUnMarshallValidation(String.valueOf((char)massiveThreeByteCharValue));
        this.doMarshallUnMarshallValidation((String)accumulator);
        int max = 65535;
        accumulator = String.valueOf(t);
        for (t = '\u0800'; t < '\uffff'; t = (char)(t + '\u0001')) {
            String val = String.valueOf(t);
            accumulator = (String)accumulator + val;
            this.doMarshallUnMarshallValidation(val);
        }
        while (((String)accumulator).length() > 20000) {
            accumulator = ((String)accumulator).substring(20000);
        }
        this.doMarshallUnMarshallValidation((String)accumulator);
    }

    void doMarshallUnMarshallValidation(String value) throws Exception {
        DataByteArrayOutputStream out = new DataByteArrayOutputStream();
        out.writeBoolean(true);
        out.writeUTF(value);
        out.close();
        DataByteArrayInputStream in = new DataByteArrayInputStream(out.getData());
        in.readBoolean();
        String readBack = in.readUTF();
        Assert.assertEquals((Object)value, (Object)readBack);
    }

    @Test
    public void testReadLong() throws Exception {
        DataByteArrayOutputStream out = new DataByteArrayOutputStream(8);
        out.writeLong(Long.MAX_VALUE);
        out.close();
        DataByteArrayInputStream in = new DataByteArrayInputStream(out.getData());
        long readBack = in.readLong();
        Assert.assertEquals((long)Long.MAX_VALUE, (long)readBack);
    }
}

