/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.command;

import javax.jms.MessageFormatException;
import org.apache.activemq.command.ActiveMQMessage;
import org.junit.Assert;
import org.junit.Test;

public class ScheduledValuesTest {
    @Test
    public void testNegativeDelay() throws Exception {
        ActiveMQMessage message = new ActiveMQMessage();
        try {
            message.setLongProperty("AMQ_SCHEDULED_DELAY", -1L);
            Assert.fail((String)"Failure expected on a negative value");
        }
        catch (MessageFormatException ex) {
            Assert.assertEquals((Object)"AMQ_SCHEDULED_DELAY must not be a negative value", (Object)ex.getMessage());
        }
    }

    @Test
    public void testNegativeRepeat() throws Exception {
        ActiveMQMessage message = new ActiveMQMessage();
        try {
            message.setIntProperty("AMQ_SCHEDULED_REPEAT", -1);
            Assert.fail((String)"Failure expected on a negative value");
        }
        catch (MessageFormatException ex) {
            Assert.assertEquals((Object)"AMQ_SCHEDULED_REPEAT must not be a negative value", (Object)ex.getMessage());
        }
    }

    @Test
    public void testNegativePeriod() throws Exception {
        ActiveMQMessage message = new ActiveMQMessage();
        try {
            message.setLongProperty("AMQ_SCHEDULED_PERIOD", -1L);
            Assert.fail((String)"Failure expected on a negative value");
        }
        catch (MessageFormatException ex) {
            Assert.assertEquals((Object)"AMQ_SCHEDULED_PERIOD must not be a negative value", (Object)ex.getMessage());
        }
    }

    @Test
    public void testScheduledDelayViaCron() throws Exception {
        ActiveMQMessage message = new ActiveMQMessage();
        try {
            message.setStringProperty("AMQ_SCHEDULED_CRON", "-1 * * * *");
            Assert.fail((String)"Failure expected on a negative value");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

