/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import java.util.LinkedList;
import java.util.List;
import org.apache.activemq.util.XASupport;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class XASupportTest {
    private final int flags;
    private final String expectedResult;

    public XASupportTest(int flags, String expectedResult) {
        this.flags = flags;
        this.expectedResult = expectedResult;
    }

    @Parameterized.Parameters
    public static Iterable<Object[]> parameters() {
        LinkedList<Object[]> p = new LinkedList<Object[]>();
        XASupportTest.add(p, 0x800000, "TMENDRSCAN");
        XASupportTest.add(p, 0x20000000, "TMFAIL");
        XASupportTest.add(p, 0x200000, "TMJOIN");
        XASupportTest.add(p, 0, "TMNOFLAGS");
        XASupportTest.add(p, 0x40000000, "TMONEPHASE");
        XASupportTest.add(p, 0x8000000, "TMRESUME");
        XASupportTest.add(p, 0x1000000, "TMSTARTRSCAN");
        XASupportTest.add(p, 0x4000000, "TMSUCCESS");
        XASupportTest.add(p, 0x2000000, "TMSUSPEND");
        XASupportTest.add(p, 0x44000000, "TMONEPHASE | TMSUCCESS");
        XASupportTest.add(p, 0x4400000, "TMSUCCESS | 0x00400000");
        return p;
    }

    private static void add(List<Object[]> p, int flags, String expectedResult) {
        p.add(new Object[]{flags, expectedResult});
    }

    @Test
    public void test() throws Exception {
        Assert.assertThat((Object)XASupport.toString((int)this.flags), (Matcher)CoreMatchers.is((Object)this.expectedResult));
    }
}

