/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import org.apache.activemq.util.StopWatch;
import org.junit.Assert;
import org.junit.Test;

public class StopWatchTest {
    @Test
    public void testStopWatch() throws Exception {
        StopWatch watch = new StopWatch();
        Thread.sleep(200L);
        long taken = watch.stop();
        Assert.assertEquals((long)taken, (long)watch.taken());
        Assert.assertTrue((String)("Should take approx 200 millis, was: " + taken), (taken > 150L ? 1 : 0) != 0);
    }

    @Test
    public void testStopWatchNotStarted() throws Exception {
        StopWatch watch = new StopWatch(false);
        long taken = watch.stop();
        Assert.assertEquals((long)0L, (long)taken);
        watch.restart();
        Thread.sleep(200L);
        taken = watch.stop();
        Assert.assertEquals((long)taken, (long)watch.taken());
        Assert.assertTrue((String)("Should take approx 200 millis, was: " + taken), (taken > 150L ? 1 : 0) != 0);
    }

    @Test
    public void testStopWatchRestart() throws Exception {
        StopWatch watch = new StopWatch();
        Thread.sleep(200L);
        long taken = watch.stop();
        Assert.assertEquals((long)taken, (long)watch.taken());
        Assert.assertTrue((String)("Should take approx 200 millis, was: " + taken), (taken > 150L ? 1 : 0) != 0);
        watch.restart();
        Thread.sleep(100L);
        taken = watch.stop();
        Assert.assertEquals((long)taken, (long)watch.taken());
        Assert.assertTrue((String)("Should take approx 100 millis, was: " + taken), (taken > 50L ? 1 : 0) != 0);
    }

    @Test
    public void testStopWatchTaken() throws Exception {
        StopWatch watch = new StopWatch();
        Thread.sleep(100L);
        long taken = watch.taken();
        Thread.sleep(100L);
        long taken2 = watch.taken();
        Assert.assertNotSame((Object)taken, (Object)taken2);
        Assert.assertTrue((taken2 > taken ? 1 : 0) != 0);
    }
}

