/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.UUID;
import java.util.Vector;
import org.apache.activemq.util.AnonymousSimplePojoParent;
import org.apache.activemq.util.ClassLoadingAwareObjectInputStream;
import org.apache.activemq.util.LocalSimplePojoParent;
import org.apache.activemq.util.SimplePojo;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class ClassLoadingAwareObjectInputStreamTest {
    private final String ACCEPTS_ALL_FILTER = "*";
    private final String ACCEPTS_NONE_FILTER = "";
    @Rule
    public TestName name = new TestName();

    @Test
    public void testReadObject() throws Exception {
        this.doTestReadObject(new SimplePojo(this.name.getMethodName()), "*");
        try {
            this.doTestReadObject(new SimplePojo(this.name.getMethodName()), "");
            Assert.fail((String)"Should have failed to read");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testReadObjectWithAnonymousClass() throws Exception {
        AnonymousSimplePojoParent pojoParent = new AnonymousSimplePojoParent(this.name.getMethodName());
        byte[] serialized = this.serializeObject(pojoParent);
        try (ByteArrayInputStream input = new ByteArrayInputStream(serialized);
             ClassLoadingAwareObjectInputStream reader = new ClassLoadingAwareObjectInputStream((InputStream)input);){
            reader.setTrustAllPackages(false);
            reader.setTrustedPackages(Arrays.asList("org.apache.activemq.util"));
            Object obj = reader.readObject();
            Assert.assertTrue((boolean)(obj instanceof AnonymousSimplePojoParent));
            Assert.assertEquals((String)"Unexpected payload", (Object)pojoParent.getPayload(), (Object)((AnonymousSimplePojoParent)obj).getPayload());
        }
    }

    @Test
    public void testReadObjectWitLocalClass() throws Exception {
        LocalSimplePojoParent pojoParent = new LocalSimplePojoParent(this.name.getMethodName());
        byte[] serialized = this.serializeObject(pojoParent);
        try (ByteArrayInputStream input = new ByteArrayInputStream(serialized);
             ClassLoadingAwareObjectInputStream reader = new ClassLoadingAwareObjectInputStream((InputStream)input);){
            reader.setTrustAllPackages(false);
            reader.setTrustedPackages(Arrays.asList("org.apache.activemq.util"));
            Object obj = reader.readObject();
            Assert.assertTrue((boolean)(obj instanceof LocalSimplePojoParent));
            Assert.assertEquals((String)"Unexpected payload", (Object)pojoParent.getPayload(), (Object)((LocalSimplePojoParent)obj).getPayload());
        }
    }

    @Test
    public void testReadObjectByte() throws Exception {
        this.doTestReadObject((byte)-1, "*");
    }

    @Test
    public void testReadObjectShort() throws Exception {
        this.doTestReadObject((short)255, "*");
    }

    @Test
    public void testReadObjectInteger() throws Exception {
        this.doTestReadObject(255, "*");
    }

    @Test
    public void testReadObjectLong() throws Exception {
        this.doTestReadObject(255L, "*");
    }

    @Test
    public void testReadObjectFloat() throws Exception {
        this.doTestReadObject(Float.valueOf(255.0f), "*");
    }

    @Test
    public void testReadObjectDouble() throws Exception {
        this.doTestReadObject(255.0, "*");
    }

    @Test
    public void testReadObjectBoolean() throws Exception {
        this.doTestReadObject(Boolean.FALSE, "*");
    }

    @Test
    public void testReadObjectString() throws Exception {
        this.doTestReadObject(new String(this.name.getMethodName()), "*");
    }

    @Test
    public void testReadObjectStringArray() throws Exception {
        String[] value = new String[]{this.name.getMethodName() + "-1", this.name.getMethodName() + "-2"};
        this.doTestReadObject(value, "*");
    }

    @Test
    public void testReadObjectMultiDimensionalArray() throws Exception {
        String[][][] value = new String[2][2][1];
        value[0][0][0] = "0-0-0";
        value[0][1][0] = "0-1-0";
        value[1][0][0] = "1-0-0";
        value[1][1][0] = "1-1-0";
        this.doTestReadObject(value, "*");
    }

    @Test
    public void testPrimitiveByteNotFiltered() throws Exception {
        this.doTestReadPrimitive((byte)-1, "");
    }

    @Test
    public void testPrimitiveShortNotFiltered() throws Exception {
        this.doTestReadPrimitive((short)255, "");
    }

    @Test
    public void testPrimitiveIntegerNotFiltered() throws Exception {
        this.doTestReadPrimitive(255, "");
    }

    @Test
    public void testPrimitiveLongNotFiltered() throws Exception {
        this.doTestReadPrimitive(255L, "");
    }

    @Test
    public void testPrimitiveFloatNotFiltered() throws Exception {
        this.doTestReadPrimitive(Float.valueOf(255.0f), "");
    }

    @Test
    public void testPrimitiveDoubleNotFiltered() throws Exception {
        this.doTestReadPrimitive(255.0, "");
    }

    @Test
    public void testPrimitiveBooleanNotFiltered() throws Exception {
        this.doTestReadPrimitive(false, "");
    }

    @Test
    public void testPrimitveCharNotFiltered() throws Exception {
        this.doTestReadPrimitive(Character.valueOf('c'), "");
    }

    @Test
    public void testReadObjectStringNotFiltered() throws Exception {
        this.doTestReadObject(new String(this.name.getMethodName()), "");
    }

    @Test
    public void testPrimitiveByteArrayNotFiltered() throws Exception {
        byte[] value = new byte[]{1, 2};
        this.doTestReadPrimitiveArray(value, "");
    }

    @Test
    public void testPrimitiveShortArrayNotFiltered() throws Exception {
        short[] value = new short[]{1, 2};
        this.doTestReadPrimitiveArray(value, "");
    }

    @Test
    public void testPrimitiveIntegerArrayNotFiltered() throws Exception {
        int[] value = new int[]{1, 2};
        this.doTestReadPrimitiveArray(value, "");
    }

    @Test
    public void testPrimitiveLongArrayNotFiltered() throws Exception {
        long[] value = new long[]{1L, 2L};
        this.doTestReadPrimitiveArray(value, "");
    }

    @Test
    public void testPrimitiveFloatArrayNotFiltered() throws Exception {
        float[] value = new float[]{1.1f, 2.1f};
        this.doTestReadPrimitiveArray(value, "");
    }

    @Test
    public void testPrimitiveDoubleArrayNotFiltered() throws Exception {
        double[] value = new double[]{1.1, 2.1};
        this.doTestReadPrimitiveArray(value, "");
    }

    @Test
    public void testReadObjectArrayFiltered() throws Exception {
        UUID[] value = new UUID[]{UUID.randomUUID(), UUID.randomUUID()};
        byte[] serialized = this.serializeObject(value);
        try (ByteArrayInputStream input = new ByteArrayInputStream(serialized);
             ClassLoadingAwareObjectInputStream reader = new ClassLoadingAwareObjectInputStream((InputStream)input);){
            reader.setTrustAllPackages(false);
            reader.setTrustedPackages(Arrays.asList("".split(",")));
            try {
                reader.readObject();
                Assert.fail((String)"Should not be able to read the payload.");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testReadObjectMixedTypeArrayGetsFiltered() throws Exception {
        Throwable throwable;
        ClassLoadingAwareObjectInputStream reader;
        Object[] value = new Object[]{this.name.getMethodName(), UUID.randomUUID(), new Vector(), new SimplePojo(this.name.getMethodName())};
        byte[] serialized = this.serializeObject(value);
        try (ByteArrayInputStream input = new ByteArrayInputStream(serialized);){
            reader = new ClassLoadingAwareObjectInputStream((InputStream)input);
            throwable = null;
            try {
                reader.setTrustAllPackages(false);
                reader.setTrustedPackages(Arrays.asList("java"));
                try {
                    reader.readObject();
                    Assert.fail((String)"Should not be able to read the payload.");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader != null) {
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        value[3] = new Integer(20);
        serialized = this.serializeObject(value);
        input = new ByteArrayInputStream(serialized);
        var4_4 = null;
        try {
            reader = new ClassLoadingAwareObjectInputStream((InputStream)input);
            throwable = null;
            try {
                reader.setTrustAllPackages(false);
                reader.setTrustedPackages(Arrays.asList("java"));
                try {
                    Object result = reader.readObject();
                    Assert.assertNotNull((Object)result);
                    Assert.assertTrue((boolean)result.getClass().isArray());
                }
                catch (ClassNotFoundException ex) {
                    Assert.fail((String)"Should be able to read the payload.");
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (reader != null) {
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var4_4 = throwable6;
            throw throwable6;
        }
        finally {
            if (input != null) {
                if (var4_4 != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable7) {
                        var4_4.addSuppressed(throwable7);
                    }
                } else {
                    input.close();
                }
            }
        }
    }

    @Test
    public void testReadObjectMultiDimensionalArrayFiltered() throws Exception {
        UUID[][] value = new UUID[2][2];
        value[0][0] = UUID.randomUUID();
        value[0][1] = UUID.randomUUID();
        value[1][0] = UUID.randomUUID();
        value[1][1] = UUID.randomUUID();
        byte[] serialized = this.serializeObject(value);
        try (ByteArrayInputStream input = new ByteArrayInputStream(serialized);
             ClassLoadingAwareObjectInputStream reader = new ClassLoadingAwareObjectInputStream((InputStream)input);){
            reader.setTrustAllPackages(false);
            reader.setTrustedPackages(Arrays.asList("".split(",")));
            try {
                reader.readObject();
                Assert.fail((String)"Should not be able to read the payload.");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testReadObjectFailsWithUntrustedType() throws Exception {
        Throwable throwable;
        ClassLoadingAwareObjectInputStream reader;
        byte[] serialized = this.serializeObject(new SimplePojo(this.name.getMethodName()));
        try (ByteArrayInputStream input = new ByteArrayInputStream(serialized);){
            reader = new ClassLoadingAwareObjectInputStream((InputStream)input);
            throwable = null;
            try {
                reader.setTrustAllPackages(false);
                reader.setTrustedPackages(Arrays.asList("java"));
                try {
                    reader.readObject();
                    Assert.fail((String)"Should not be able to read the payload.");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader != null) {
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        serialized = this.serializeObject(UUID.randomUUID());
        input = new ByteArrayInputStream(serialized);
        var3_3 = null;
        try {
            reader = new ClassLoadingAwareObjectInputStream((InputStream)input);
            throwable = null;
            try {
                try {
                    reader.readObject();
                }
                catch (ClassNotFoundException ex) {
                    Assert.fail((String)"Should be able to read the payload.");
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (reader != null) {
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var3_3 = throwable6;
            throw throwable6;
        }
        finally {
            if (input != null) {
                if (var3_3 != null) {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable7) {
                        var3_3.addSuppressed(throwable7);
                    }
                } else {
                    input.close();
                }
            }
        }
    }

    @Test
    public void testReadObjectFailsWithUnstrustedContentInTrustedType() throws Exception {
        byte[] serialized = this.serializeObject(new SimplePojo(UUID.randomUUID()));
        ByteArrayInputStream input = new ByteArrayInputStream(serialized);
        try (ClassLoadingAwareObjectInputStream reader = new ClassLoadingAwareObjectInputStream((InputStream)input);){
            reader.setTrustAllPackages(false);
            reader.setTrustedPackages(Arrays.asList("org.apache.activemq"));
            try {
                reader.readObject();
                Assert.fail((String)"Should not be able to read the payload.");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        serialized = this.serializeObject(UUID.randomUUID());
        input = new ByteArrayInputStream(serialized);
        reader = new ClassLoadingAwareObjectInputStream((InputStream)input);
        var4_4 = null;
        try {
            reader.setTrustAllPackages(false);
            reader.setTrustedPackages(Arrays.asList("org.apache.activemq"));
            try {
                reader.readObject();
                Assert.fail((String)"Should not be able to read the payload.");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (reader != null) {
                if (var4_4 != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    reader.close();
                }
            }
        }
    }

    private void doTestReadObject(Object value, String filter) throws Exception {
        byte[] serialized = this.serializeObject(value);
        try (ByteArrayInputStream input = new ByteArrayInputStream(serialized);
             ClassLoadingAwareObjectInputStream reader = new ClassLoadingAwareObjectInputStream((InputStream)input);){
            reader.setTrustAllPackages(false);
            reader.setTrustedPackages(Arrays.asList(filter.split(",")));
            Object result = reader.readObject();
            Assert.assertNotNull((Object)result);
            Assert.assertEquals(value.getClass(), result.getClass());
            if (result.getClass().isArray()) {
                Assert.assertTrue((boolean)Arrays.deepEquals((Object[])value, (Object[])result));
            } else {
                Assert.assertEquals((Object)value, (Object)result);
            }
        }
    }

    private byte[] serializeObject(Object value) throws IOException {
        byte[] result = new byte[]{};
        if (value != null) {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                 ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(value);
                oos.flush();
                oos.close();
                result = baos.toByteArray();
            }
        }
        return result;
    }

    private void doTestReadPrimitive(Object value, String filter) throws Exception {
        byte[] serialized = this.serializePrimitive(value);
        try (ByteArrayInputStream input = new ByteArrayInputStream(serialized);
             ClassLoadingAwareObjectInputStream reader = new ClassLoadingAwareObjectInputStream((InputStream)input);){
            reader.setTrustAllPackages(false);
            reader.setTrustedPackages(Arrays.asList(filter.split(",")));
            Comparable<Byte> result = null;
            if (value instanceof Byte) {
                result = reader.readByte();
            } else if (value instanceof Short) {
                result = reader.readShort();
            } else if (value instanceof Integer) {
                result = reader.readInt();
            } else if (value instanceof Long) {
                result = reader.readLong();
            } else if (value instanceof Float) {
                result = Float.valueOf(reader.readFloat());
            } else if (value instanceof Double) {
                result = reader.readDouble();
            } else if (value instanceof Boolean) {
                result = reader.readBoolean();
            } else if (value instanceof Character) {
                result = Character.valueOf(reader.readChar());
            } else {
                throw new IllegalArgumentException("unsuitable type for primitive deserialization");
            }
            Assert.assertNotNull((Object)result);
            Assert.assertEquals(value.getClass(), result.getClass());
            Assert.assertEquals((Object)value, (Object)result);
        }
    }

    private void doTestReadPrimitiveArray(Object value, String filter) throws Exception {
        byte[] serialized = this.serializeObject(value);
        try (ByteArrayInputStream input = new ByteArrayInputStream(serialized);
             ClassLoadingAwareObjectInputStream reader = new ClassLoadingAwareObjectInputStream((InputStream)input);){
            reader.setTrustAllPackages(false);
            reader.setTrustedPackages(Arrays.asList(filter.split(",")));
            Object result = reader.readObject();
            Assert.assertNotNull((Object)result);
            Assert.assertEquals(value.getClass(), result.getClass());
            Assert.assertTrue((boolean)result.getClass().isArray());
            Assert.assertEquals(value.getClass().getComponentType(), result.getClass().getComponentType());
            Assert.assertTrue((boolean)result.getClass().getComponentType().isPrimitive());
        }
    }

    private byte[] serializePrimitive(Object value) throws IOException {
        byte[] result = new byte[]{};
        if (value != null) {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                 ObjectOutputStream oos = new ObjectOutputStream(baos);){
                if (value instanceof Byte) {
                    oos.writeByte(((Byte)value).byteValue());
                } else if (value instanceof Short) {
                    oos.writeShort(((Short)value).shortValue());
                } else if (value instanceof Integer) {
                    oos.writeInt((Integer)value);
                } else if (value instanceof Long) {
                    oos.writeLong((Long)value);
                } else if (value instanceof Float) {
                    oos.writeFloat(((Float)value).floatValue());
                } else if (value instanceof Double) {
                    oos.writeDouble((Double)value);
                } else if (value instanceof Boolean) {
                    oos.writeBoolean((Boolean)value);
                } else if (value instanceof Character) {
                    oos.writeChar(((Character)value).charValue());
                } else {
                    throw new IllegalArgumentException("unsuitable type for primitive serialization");
                }
                oos.flush();
                oos.close();
                result = baos.toByteArray();
            }
        }
        return result;
    }

    static {
        System.setProperty("org.apache.activemq.SERIALIZABLE_PACKAGES", "java.util");
    }
}

