/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.thread;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.thread.Scheduler;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SchedulerTest {
    private static final String schedulerName = "testScheduler";
    private Scheduler scheduler;

    @Before
    public void before() throws Exception {
        this.scheduler = new Scheduler(schedulerName);
        this.scheduler.start();
    }

    @After
    public void after() throws Exception {
        this.scheduler.stop();
    }

    @Test
    public void testExecutePeriodically() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.scheduler.executePeriodically((Runnable)new CountDownRunnable(latch), 10L);
        Assert.assertTrue((boolean)latch.await(5000L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void executeAfterDelay() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.scheduler.executeAfterDelay((Runnable)new CountDownRunnable(latch), 10L);
        Assert.assertTrue((boolean)latch.await(5000L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testExecutePeriodicallyReplace() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        CountDownRunnable task = new CountDownRunnable(latch);
        this.scheduler.executePeriodically((Runnable)task, 500L);
        this.scheduler.executePeriodically((Runnable)task, 500L);
        this.scheduler.cancel((Runnable)task);
        Assert.assertFalse((boolean)latch.await(1000L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testExecutePeriodicallyTaskExceptionDoesNotBreakTimer() throws Exception {
        CountDownLatch latch = new CountDownLatch(10);
        this.scheduler.executePeriodically((Runnable)new CountDownRunnable(latch, 5L), 10L);
        Assert.assertTrue((boolean)latch.await(5000L, TimeUnit.MILLISECONDS));
    }

    private static class CountDownRunnable
    implements Runnable {
        final CountDownLatch latch;
        final Long throwAtCount;

        CountDownRunnable(CountDownLatch latch) {
            this(latch, null);
        }

        CountDownRunnable(CountDownLatch latch, Long throwAtCount) {
            this.latch = latch;
            this.throwAtCount = throwAtCount;
        }

        @Override
        public void run() {
            this.latch.countDown();
            if (this.throwAtCount != null && this.latch.getCount() == this.throwAtCount.longValue()) {
                throw new RuntimeException("You never want this to happen in a real task!!");
            }
        }
    }
}

