/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.interceptor;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerRegistry;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.broker.inteceptor.MessageInterceptor;
import org.apache.activemq.broker.inteceptor.MessageInterceptorRegistry;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;

public class MessageInterceptorTest
extends TestCase {
    protected BrokerService brokerService;
    protected ActiveMQConnectionFactory factory;
    protected Connection producerConnection;
    protected Connection consumerConnection;
    protected Session consumerSession;
    protected Session producerSession;
    protected MessageConsumer consumer;
    protected MessageProducer producer;
    protected Topic topic;
    protected int messageCount = 10000;
    protected int timeOutInSeconds = 10;

    protected void setUp() throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setPersistent(false);
        this.brokerService.start();
        this.factory = new ActiveMQConnectionFactory(BrokerRegistry.getInstance().findFirst().getVmConnectorURI());
        this.consumerConnection = this.factory.createConnection();
        this.consumerConnection.start();
        this.producerConnection = this.factory.createConnection();
        this.producerConnection.start();
        this.consumerSession = this.consumerConnection.createSession(false, 1);
        this.topic = this.consumerSession.createTopic(this.getName());
        this.producerSession = this.producerConnection.createSession(false, 1);
        this.consumer = this.consumerSession.createConsumer((Destination)this.topic);
        this.producer = this.producerSession.createProducer((Destination)this.topic);
    }

    protected void tearDown() throws Exception {
        if (this.producerConnection != null) {
            this.producerConnection.close();
        }
        if (this.consumerConnection != null) {
            this.consumerConnection.close();
        }
        if (this.brokerService != null) {
            this.brokerService.stop();
        }
    }

    public void testNoIntercept() throws Exception {
        final CountDownLatch latch = new CountDownLatch(this.messageCount);
        this.consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                latch.countDown();
            }
        });
        for (int i = 0; i < this.messageCount; ++i) {
            TextMessage message = this.producerSession.createTextMessage("test: " + i);
            this.producer.send((Message)message);
        }
        latch.await(this.timeOutInSeconds, TimeUnit.SECONDS);
        MessageInterceptorTest.assertEquals((long)0L, (long)latch.getCount());
    }

    public void testNoStackOverFlow() throws Exception {
        final MessageInterceptorRegistry registry = MessageInterceptorRegistry.getInstance().get(BrokerRegistry.getInstance().findFirst());
        registry.addMessageInterceptorForTopic(this.topic.getTopicName(), new MessageInterceptor(){

            public void intercept(ProducerBrokerExchange producerExchange, org.apache.activemq.command.Message message) {
                try {
                    registry.injectMessage(producerExchange, message);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        final CountDownLatch latch = new CountDownLatch(this.messageCount);
        this.consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                latch.countDown();
            }
        });
        for (int i = 0; i < this.messageCount; ++i) {
            TextMessage message = this.producerSession.createTextMessage("test: " + i);
            this.producer.send((Message)message);
        }
        latch.await(this.timeOutInSeconds, TimeUnit.SECONDS);
        MessageInterceptorTest.assertEquals((long)0L, (long)latch.getCount());
    }

    public void testInterceptorAll() throws Exception {
        MessageInterceptorRegistry registry = MessageInterceptorRegistry.getInstance().get(BrokerRegistry.getInstance().findFirst());
        registry.addMessageInterceptorForTopic(this.topic.getTopicName(), new MessageInterceptor(){

            public void intercept(ProducerBrokerExchange producerExchange, org.apache.activemq.command.Message message) {
            }
        });
        final CountDownLatch latch = new CountDownLatch(this.messageCount);
        this.consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                latch.countDown();
            }
        });
        for (int i = 0; i < this.messageCount; ++i) {
            TextMessage message = this.producerSession.createTextMessage("test: " + i);
            this.producer.send((Message)message);
        }
        latch.await(this.timeOutInSeconds, TimeUnit.SECONDS);
        MessageInterceptorTest.assertEquals((long)this.messageCount, (long)latch.getCount());
    }

    public void testReRouteAll() throws Exception {
        final ActiveMQQueue queue = new ActiveMQQueue("Reroute.From." + this.topic.getTopicName());
        final MessageInterceptorRegistry registry = MessageInterceptorRegistry.getInstance().get(BrokerRegistry.getInstance().findFirst());
        registry.addMessageInterceptorForTopic(this.topic.getTopicName(), new MessageInterceptor(){

            public void intercept(ProducerBrokerExchange producerExchange, org.apache.activemq.command.Message message) {
                message.setDestination((ActiveMQDestination)queue);
                try {
                    registry.injectMessage(producerExchange, message);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        final CountDownLatch latch = new CountDownLatch(this.messageCount);
        this.consumer = this.consumerSession.createConsumer((Destination)queue);
        this.consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                latch.countDown();
            }
        });
        for (int i = 0; i < this.messageCount; ++i) {
            TextMessage message = this.producerSession.createTextMessage("test: " + i);
            this.producer.send((Message)message);
        }
        latch.await(this.timeOutInSeconds, TimeUnit.SECONDS);
        MessageInterceptorTest.assertEquals((long)0L, (long)latch.getCount());
    }

    public void testReRouteAllWithNullProducerExchange() throws Exception {
        final ActiveMQQueue queue = new ActiveMQQueue("Reroute.From." + this.topic.getTopicName());
        final MessageInterceptorRegistry registry = MessageInterceptorRegistry.getInstance().get(BrokerRegistry.getInstance().findFirst());
        registry.addMessageInterceptorForTopic(this.topic.getTopicName(), new MessageInterceptor(){

            public void intercept(ProducerBrokerExchange producerExchange, org.apache.activemq.command.Message message) {
                message.setDestination((ActiveMQDestination)queue);
                try {
                    registry.injectMessage(producerExchange, message);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        final CountDownLatch latch = new CountDownLatch(this.messageCount);
        this.consumer = this.consumerSession.createConsumer((Destination)queue);
        this.consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                latch.countDown();
            }
        });
        for (int i = 0; i < this.messageCount; ++i) {
            TextMessage message = this.producerSession.createTextMessage("test: " + i);
            this.producer.send((Message)message);
        }
        latch.await(this.timeOutInSeconds, TimeUnit.SECONDS);
        MessageInterceptorTest.assertEquals((long)0L, (long)latch.getCount());
    }

    public void testReRouteAllowWildCards() throws Exception {
        final ActiveMQQueue testQueue = new ActiveMQQueue("testQueueFor." + this.getName());
        final MessageInterceptorRegistry registry = MessageInterceptorRegistry.getInstance().get(BrokerRegistry.getInstance().findFirst());
        registry.addMessageInterceptorForTopic(">", new MessageInterceptor(){

            public void intercept(ProducerBrokerExchange producerExchange, org.apache.activemq.command.Message message) {
                try {
                    message.setDestination((ActiveMQDestination)testQueue);
                    registry.injectMessage(producerExchange, message);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        final CountDownLatch latch = new CountDownLatch(this.messageCount);
        this.consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                latch.countDown();
            }
        });
        MessageConsumer consumer1 = this.consumerSession.createConsumer((Destination)testQueue);
        consumer1.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                latch.countDown();
            }
        });
        for (int i = 0; i < this.messageCount; ++i) {
            TextMessage message = this.producerSession.createTextMessage("test: " + i);
            this.producer.send((Message)message);
        }
        latch.await(this.timeOutInSeconds, TimeUnit.SECONDS);
        MessageInterceptorTest.assertEquals((long)0L, (long)latch.getCount());
    }
}

