/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerFilter;
import org.apache.activemq.broker.BrokerService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BrokerInterceptorsTest {
    private BrokerService brokerService;

    @Before
    public void setUp() throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setAdvisorySupport(true);
        this.brokerService.setPersistent(false);
        this.brokerService.setUseJmx(false);
        this.brokerService.start();
    }

    @After
    public void tearDown() throws Exception {
        if (this.brokerService != null) {
            this.brokerService.stop();
        }
    }

    @Test
    public void testNavigateInterceptors() throws Exception {
        Broker b = this.brokerService.getBroker();
        Assert.assertTrue((boolean)(b instanceof BrokerFilter));
        BrokerFilter bf = (BrokerFilter)b;
        int count = 0;
        while (bf != null) {
            Broker next = bf.getNext();
            bf = next instanceof BrokerFilter ? (BrokerFilter)next : null;
            ++count;
        }
        Assert.assertTrue((count > 1 ? 1 : 0) != 0);
    }
}

