/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.activemq.JmsTransactionTestSupport;
import org.apache.activemq.test.JmsResourceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsQueueTransactionTest
extends JmsTransactionTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(JmsQueueTransactionTest.class);

    @Override
    protected JmsResourceProvider getJmsResourceProvider() {
        JmsResourceProvider p = new JmsResourceProvider();
        p.setTopic(false);
        return p;
    }

    public void testReceiveTwoThenCloseConnection() throws Exception {
        Message[] outbound = new Message[]{this.session.createTextMessage("First Message"), this.session.createTextMessage("Second Message")};
        this.beginTx();
        while (this.consumer.receive(1000L) != null) {
        }
        this.commitTx();
        this.beginTx();
        this.producer.send(outbound[0]);
        this.producer.send(outbound[1]);
        this.commitTx();
        LOG.info("Sent 0: " + String.valueOf(outbound[0]));
        LOG.info("Sent 1: " + String.valueOf(outbound[1]));
        ArrayList<Message> messages = new ArrayList<Message>();
        this.beginTx();
        Message message = this.consumer.receive(2000L);
        this.assertEquals(outbound[0], message);
        message = this.consumer.receive(2000L);
        JmsQueueTransactionTest.assertNotNull((Object)message);
        this.assertEquals(outbound[1], message);
        this.reconnect();
        this.beginTx();
        message = this.consumer.receive(2000L);
        JmsQueueTransactionTest.assertNotNull((String)"Should have re-received the first message again!", (Object)message);
        messages.add(message);
        this.assertEquals(outbound[0], message);
        message = this.consumer.receive(5000L);
        JmsQueueTransactionTest.assertNotNull((String)"Should have re-received the second message again!", (Object)message);
        messages.add(message);
        this.assertEquals(outbound[1], message);
        this.commitTx();
        Message[] inbound = new Message[messages.size()];
        messages.toArray(inbound);
        this.assertTextMessagesEqual("Rollback did not work", outbound, inbound);
    }

    public void testSendReceiveInSeparatedSessionTest() throws Exception {
        this.session.close();
        int batchCount = 10;
        for (int i = 0; i < batchCount; ++i) {
            Session session;
            this.session = session = this.resourceProvider.createSession(this.connection);
            MessageProducer producer = this.resourceProvider.createProducer(session, this.destination);
            this.beginTx();
            producer.send((Message)session.createTextMessage("Test Message: " + i));
            this.commitTx();
            session.close();
            this.session = session = this.resourceProvider.createSession(this.connection);
            MessageConsumer consumer = this.resourceProvider.createConsumer(session, this.destination);
            this.beginTx();
            TextMessage message = (TextMessage)consumer.receive(5000L);
            JmsQueueTransactionTest.assertNotNull((String)("Received only " + i + " messages in batch "), (Object)message);
            JmsQueueTransactionTest.assertEquals((String)("Test Message: " + i), (String)message.getText());
            this.commitTx();
            session.close();
        }
    }

    public void testReceiveBrowseReceive() throws Exception {
        Message[] outbound = new Message[]{this.session.createTextMessage("First Message"), this.session.createTextMessage("Second Message"), this.session.createTextMessage("Third Message")};
        this.beginTx();
        while (this.consumer.receive(1000L) != null) {
        }
        this.commitTx();
        this.beginTx();
        this.producer.send(outbound[0]);
        this.producer.send(outbound[1]);
        this.producer.send(outbound[2]);
        this.commitTx();
        this.beginTx();
        this.assertEquals(outbound[0], this.consumer.receive(1000L));
        this.consumer.close();
        this.commitTx();
        this.beginTx();
        QueueBrowser browser = this.session.createBrowser((Queue)this.destination);
        Enumeration enumeration = browser.getEnumeration();
        JmsQueueTransactionTest.assertTrue((String)"should have received the second message", (boolean)enumeration.hasMoreElements());
        this.assertEquals(outbound[1], (Message)enumeration.nextElement());
        JmsQueueTransactionTest.assertTrue((String)"Should have received the third message", (boolean)enumeration.hasMoreElements());
        this.assertEquals(outbound[2], (Message)enumeration.nextElement());
        LOG.info("Check for more...");
        boolean tooMany = false;
        while (enumeration.hasMoreElements()) {
            LOG.info("Got extra message: " + ((TextMessage)enumeration.nextElement()).getText());
            tooMany = true;
        }
        JmsQueueTransactionTest.assertFalse((boolean)tooMany);
        LOG.info("close browser...");
        browser.close();
        LOG.info("reopen and consume...");
        this.consumer = this.resourceProvider.createConsumer(this.session, this.destination);
        this.assertEquals(outbound[1], this.consumer.receive(1000L));
        this.assertEquals(outbound[2], this.consumer.receive(1000L));
        this.consumer.close();
        this.commitTx();
    }

    public void testCloseConsumer() throws Exception {
        Queue dest = this.session.createQueue(this.getSubject() + "?consumer.prefetchSize=0");
        this.producer = this.session.createProducer((Destination)dest);
        this.beginTx();
        this.producer.send((Message)this.session.createTextMessage("message 1"));
        this.producer.send((Message)this.session.createTextMessage("message 2"));
        this.commitTx();
        this.beginTx();
        this.consumer = this.session.createConsumer((Destination)dest);
        Message message1 = this.consumer.receive(1000L);
        String text1 = ((TextMessage)message1).getText();
        JmsQueueTransactionTest.assertNotNull((Object)message1);
        JmsQueueTransactionTest.assertEquals((String)"message 1", (String)text1);
        this.consumer.close();
        this.consumer = this.session.createConsumer((Destination)dest);
        Message message2 = this.consumer.receive(1000L);
        String text2 = ((TextMessage)message2).getText();
        JmsQueueTransactionTest.assertNotNull((Object)message2);
        JmsQueueTransactionTest.assertEquals((String)"message 2", (String)text2);
        this.commitTx();
    }
}

