/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import jakarta.jms.Connection;
import java.net.URI;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnection;
import org.apache.activemq.broker.TransportConnector;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OpenwireConnectionTest {
    BrokerService broker;
    URI brokerConnectURI;

    @Before
    public void startBroker() throws Exception {
        this.broker = new BrokerService();
        this.broker.setPersistent(false);
        TransportConnector connector = this.broker.addConnector(new TransportConnector());
        connector.setUri(new URI("tcp://0.0.0.0:0"));
        connector.setName("tcp");
        this.broker.start();
        this.broker.waitUntilStarted();
        this.brokerConnectURI = this.broker.getConnectorByName("tcp").getConnectUri();
    }

    @After
    public void stopBroker() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
    }

    @Test
    public void testAMQ5050DefaultHost() throws Exception {
        Connection connection = new ActiveMQConnectionFactory(this.brokerConnectURI).createConnection();
        connection.start();
        CopyOnWriteArrayList connections = this.broker.getConnectorByName("tcp").getConnections();
        Assert.assertEquals((long)1L, (long)connections.size());
        Assert.assertNotNull((Object)((TransportConnection)connections.get(0)).getRemoteWireFormatInfo().getHost());
        connection.stop();
    }

    @Test
    public void testAMQ5050WithManualSpecifiedHost() throws Exception {
        Connection connection = new ActiveMQConnectionFactory(this.brokerConnectURI + "?wireFormat.host=foo").createConnection();
        connection.start();
        CopyOnWriteArrayList connections = this.broker.getConnectorByName("tcp").getConnections();
        Assert.assertEquals((long)1L, (long)connections.size());
        Assert.assertEquals((Object)"foo", (Object)((TransportConnection)connections.get(0)).getRemoteWireFormatInfo().getHost());
        connection.stop();
    }
}

