/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.plugin;

import org.apache.activemq.plugin.SubQueueSelectorCacheBroker;
import org.junit.Assert;
import org.junit.Test;

public class SubQueueSelectorCacheBrokerWildcardTest {
    @Test
    public void testSimpleWildcardEvaluation() {
        SubQueueSelectorCacheBrokerWildcardTest.assertWildcard(true, "modelInstanceId = '170' AND modelClassId LIKE 'com.whatever.something.%'");
        SubQueueSelectorCacheBrokerWildcardTest.assertWildcard(true, "JMSMessageId LIKE '%'");
        SubQueueSelectorCacheBrokerWildcardTest.assertWildcard(false, "modelClassId = 'com.whatever.something.%'");
    }

    @Test
    public void testEscapedWildcardEvaluation() {
        SubQueueSelectorCacheBrokerWildcardTest.assertWildcard(true, "foo LIKE '!_%' ESCAPE '!'");
        SubQueueSelectorCacheBrokerWildcardTest.assertWildcard(false, "_foo__ LIKE '!_!%' ESCAPE '!'");
        SubQueueSelectorCacheBrokerWildcardTest.assertWildcard(true, "_foo_ LIKE '_%' ESCAPE '.'");
        SubQueueSelectorCacheBrokerWildcardTest.assertWildcard(true, "JMSMessageId LIKE '%' ESCAPE '.'");
        SubQueueSelectorCacheBrokerWildcardTest.assertWildcard(false, "_foo_ LIKE '\\_\\%' ESCAPE '\\'");
    }

    @Test
    public void testNonWildard() {
        SubQueueSelectorCacheBrokerWildcardTest.assertWildcard(false, "type = 'UPDATE_ENTITY'");
        SubQueueSelectorCacheBrokerWildcardTest.assertWildcard(false, "a_property = 1");
        SubQueueSelectorCacheBrokerWildcardTest.assertWildcard(false, "percentage = '100%'");
    }

    @Test
    public void testApostrophes() {
        SubQueueSelectorCacheBrokerWildcardTest.assertWildcard(true, "quote LIKE '''In G_d We Trust'''");
        SubQueueSelectorCacheBrokerWildcardTest.assertWildcard(true, "quote LIKE '''In Gd We Trust''' OR quote not like '''In G_d We Trust'''");
    }

    static void assertWildcard(boolean expected, String selector) {
        Assert.assertEquals((String)("Wildcard should " + (!expected ? " NOT " : "") + " be found in " + selector), (Object)expected, (Object)SubQueueSelectorCacheBroker.hasWildcards((String)selector));
    }
}

