/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.BrokerView;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AMQ7085Test {
    private BrokerService brokerService;
    private String testQueueName = "testAMQ7085Queue";
    private ActiveMQQueue queue = new ActiveMQQueue(this.testQueueName);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setUp() throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setPersistent(false);
        this.brokerService.setUseJmx(true);
        String connectionUri = this.brokerService.addConnector("tcp://localhost:0").getPublishableConnectString();
        this.brokerService.start();
        this.brokerService.waitUntilStarted();
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(connectionUri);
        try (Connection conn = connectionFactory.createConnection();){
            conn.start();
            Session session = conn.createSession(false, 1);
            Queue queue = session.createQueue(this.testQueueName);
            Message toSend = session.createMessage();
            toSend.setStringProperty("foo", "bar");
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.send((Destination)queue, toSend);
        }
    }

    @After
    public void tearDown() throws Exception {
        this.brokerService.stop();
        this.brokerService.waitUntilStopped();
    }

    @Test
    public void testQueueTempUsageWhenSetExplicitly() throws Exception {
        ObjectName queueViewMBeanName = new ObjectName("org.apache.activemq:type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + this.queue.getQueueName());
        QueueViewMBean queueViewMBean = (QueueViewMBean)this.brokerService.getManagementContext().newProxyInstance(queueViewMBeanName, QueueViewMBean.class, true);
        BrokerView brokerView = this.brokerService.getAdminView();
        long brokerTempLimit = brokerView.getTempLimit();
        Assert.assertEquals((long)brokerTempLimit, (long)queueViewMBean.getTempUsageLimit());
        long queueTempLimit = brokerTempLimit + 111L;
        queueViewMBean.setTempUsageLimit(queueTempLimit);
        Assert.assertEquals((long)queueViewMBean.getTempUsageLimit(), (long)queueTempLimit);
        Assert.assertEquals((long)brokerView.getTempLimit(), (long)brokerTempLimit);
        long newBrokerTempLimit = brokerTempLimit + 555L;
        brokerView.setTempLimit(newBrokerTempLimit);
        Assert.assertEquals((long)brokerView.getTempLimit(), (long)newBrokerTempLimit);
        Assert.assertEquals((long)queueViewMBean.getTempUsageLimit(), (long)queueTempLimit);
        this.brokerService.getDestination((ActiveMQDestination)this.queue).stop();
        Assert.assertFalse((boolean)this.brokerService.getDestination((ActiveMQDestination)this.queue).getTempUsage().isStarted());
    }

    @Test
    public void testQueueTempUsageWhenBrokerTempUsageUpdated() throws Exception {
        ObjectName queueViewMBeanName = new ObjectName("org.apache.activemq:type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + this.queue.getQueueName());
        QueueViewMBean queueViewMBean = (QueueViewMBean)this.brokerService.getManagementContext().newProxyInstance(queueViewMBeanName, QueueViewMBean.class, true);
        BrokerView brokerView = this.brokerService.getAdminView();
        long brokerTempLimit = brokerView.getTempLimit();
        Assert.assertEquals((long)brokerTempLimit, (long)queueViewMBean.getTempUsageLimit());
        long newBrokerTempLimit = brokerTempLimit + 555L;
        brokerView.setTempLimit(newBrokerTempLimit);
        Assert.assertEquals((long)brokerView.getTempLimit(), (long)newBrokerTempLimit);
        Assert.assertEquals((long)queueViewMBean.getTempUsageLimit(), (long)newBrokerTempLimit);
        this.brokerService.getDestination((ActiveMQDestination)this.queue).stop();
        Assert.assertFalse((boolean)this.brokerService.getDestination((ActiveMQDestination)this.queue).getTempUsage().isStarted());
    }
}

