/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.BrokerInfo;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TransportConnectorTest {
    TransportConnector underTest;

    @Before
    public void init() throws Exception {
        this.underTest = new TransportConnector();
        this.underTest.setBrokerService(new BrokerService());
    }

    @Test
    public void addPeerBrokerWithFilter() throws Exception {
        this.underTest.setUpdateClusterFilter("e.*,w.*");
        String validName = "west";
        BrokerInfo brokerInfo = new BrokerInfo();
        brokerInfo.setBrokerURL("west");
        brokerInfo.setBrokerName("west");
        Assert.assertFalse((boolean)this.underTest.getPeerBrokers().contains("west"));
        this.underTest.addPeerBroker(brokerInfo);
        Assert.assertTrue((boolean)this.underTest.getPeerBrokers().contains("west"));
        String validName2 = "east";
        brokerInfo = new BrokerInfo();
        brokerInfo.setBrokerURL("east");
        brokerInfo.setBrokerName("east");
        Assert.assertFalse((boolean)this.underTest.getPeerBrokers().contains("east"));
        this.underTest.addPeerBroker(brokerInfo);
        Assert.assertTrue((boolean)this.underTest.getPeerBrokers().contains("east"));
        String inValidName = "boo";
        brokerInfo = new BrokerInfo();
        brokerInfo.setBrokerURL("boo");
        brokerInfo.setBrokerName("boo");
        Assert.assertFalse((boolean)this.underTest.getPeerBrokers().contains("boo"));
        this.underTest.addPeerBroker(brokerInfo);
        Assert.assertFalse((boolean)this.underTest.getPeerBrokers().contains("boo"));
    }

    @Test
    public void addPeerBrokerWithoutFilter() throws Exception {
        this.underTest.setBrokerService(new BrokerService());
        String validName = "west";
        BrokerInfo brokerInfo = new BrokerInfo();
        brokerInfo.setBrokerURL("west");
        brokerInfo.setBrokerName("west");
        Assert.assertFalse((boolean)this.underTest.getPeerBrokers().contains("west"));
        this.underTest.addPeerBroker(brokerInfo);
        Assert.assertTrue((boolean)this.underTest.getPeerBrokers().contains("west"));
        String validName2 = "east";
        brokerInfo = new BrokerInfo();
        brokerInfo.setBrokerURL("east");
        brokerInfo.setBrokerName("east");
        Assert.assertFalse((boolean)this.underTest.getPeerBrokers().contains("east"));
        this.underTest.addPeerBroker(brokerInfo);
        Assert.assertTrue((boolean)this.underTest.getPeerBrokers().contains("east"));
    }
}

