/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import org.apache.activemq.broker.BrokerService;
import org.junit.Assert;
import org.junit.Test;

public class BrokerServiceTest {
    @Test
    public void removedPreShutdownHooksShouldNotBeInvokedWhenStopping() throws Exception {
        BrokerService brokerService = new BrokerService();
        Hook hook = new Hook();
        brokerService.addPreShutdownHook((Runnable)hook);
        brokerService.removePreShutdownHook((Runnable)hook);
        brokerService.stop();
        Assert.assertFalse((String)"Removed pre-shutdown hook should not have been invoked", (boolean)hook.invoked);
    }

    @Test
    public void shouldInvokePreShutdownHooksBeforeStopping() throws Exception {
        BrokerService brokerService = new BrokerService();
        Hook hook = new Hook();
        brokerService.addPreShutdownHook((Runnable)hook);
        brokerService.stop();
        Assert.assertTrue((String)"Pre-shutdown hook should have been invoked", (boolean)hook.invoked);
    }

    static class Hook
    implements Runnable {
        boolean invoked = false;

        Hook() {
        }

        @Override
        public void run() {
            this.invoked = true;
        }
    }
}

