/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.net.URI;
import java.util.HashMap;
import org.apache.activemq.network.DemandForwardingBridge;
import org.apache.activemq.network.DurableConduitBridge;
import org.apache.activemq.network.NetworkBridgeConfiguration;
import org.apache.activemq.network.NetworkBridgeListener;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.util.URISupport;

public final class NetworkBridgeFactory {
    private NetworkBridgeFactory() {
    }

    public static DemandForwardingBridge createBridge(NetworkBridgeConfiguration configuration, Transport localTransport, Transport remoteTransport, NetworkBridgeListener listener) {
        DemandForwardingBridge result = null;
        result = configuration.isConduitSubscriptions() ? new DurableConduitBridge(configuration, localTransport, remoteTransport) : new DemandForwardingBridge(configuration, localTransport, remoteTransport);
        if (listener != null) {
            result.setNetworkBridgeListener(listener);
        }
        return result;
    }

    public static Transport createLocalTransport(NetworkBridgeConfiguration configuration, URI uri) throws Exception {
        return NetworkBridgeFactory.createLocalTransport(uri, !configuration.isDispatchAsync());
    }

    public static Transport createLocalAsyncTransport(URI uri) throws Exception {
        return NetworkBridgeFactory.createLocalTransport(uri, true);
    }

    private static Transport createLocalTransport(URI uri, boolean async) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>(URISupport.parseParameters((URI)uri));
        map.put("async", String.valueOf(async));
        map.put("create", "false");
        uri = URISupport.createURIWithQuery((URI)uri, (String)URISupport.createQueryString(map));
        return TransportFactory.connect((URI)uri);
    }
}

