/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp.message;

import jakarta.jms.JMSException;
import jakarta.jms.MessageNotWriteableException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQMapMessage;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQObjectMessage;
import org.apache.activemq.command.ActiveMQStreamMessage;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.transport.amqp.AmqpProtocolException;
import org.apache.activemq.transport.amqp.message.AMQPNativeInboundTransformer;
import org.apache.activemq.transport.amqp.message.AmqpMessageSupport;
import org.apache.activemq.transport.amqp.message.EncodedMessage;
import org.apache.activemq.transport.amqp.message.InboundTransformer;
import org.apache.activemq.util.ByteSequence;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.Message;

public class JMSMappingInboundTransformer
extends InboundTransformer {
    @Override
    public String getTransformerName() {
        return "jms";
    }

    @Override
    public InboundTransformer getFallbackTransformer() {
        return new AMQPNativeInboundTransformer();
    }

    @Override
    protected ActiveMQMessage doTransform(EncodedMessage amqpMessage) throws Exception {
        Message amqp = amqpMessage.decode();
        ActiveMQMessage result = this.createMessage(amqp, amqpMessage);
        this.populateMessage(result, amqp);
        if (amqpMessage.getMessageFormat() != 0L) {
            result.setLongProperty("JMS_AMQP_MESSAGE_FORMAT", amqpMessage.getMessageFormat());
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ActiveMQMessage createMessage(Message message, EncodedMessage original) throws Exception {
        void var4_24;
        Section body = message.getBody();
        if (body == null) {
            void var4_8;
            if (AmqpMessageSupport.isContentType("application/x-java-serialized-object", message)) {
                ActiveMQObjectMessage activeMQObjectMessage = new ActiveMQObjectMessage();
            } else if (AmqpMessageSupport.isContentType("application/octet-stream", message) || AmqpMessageSupport.isContentType(null, message)) {
                ActiveMQBytesMessage activeMQBytesMessage = new ActiveMQBytesMessage();
            } else {
                Charset charset = AmqpMessageSupport.getCharsetForTextualContent(message.getContentType());
                if (charset != null) {
                    ActiveMQTextMessage activeMQTextMessage = new ActiveMQTextMessage();
                } else {
                    ActiveMQMessage activeMQMessage = new ActiveMQMessage();
                }
            }
            var4_8.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", (short)1);
            return var4_24;
        } else if (body instanceof Data) {
            void var4_15;
            Binary payload = ((Data)body).getValue();
            if (AmqpMessageSupport.isContentType("application/x-java-serialized-object", message)) {
                ActiveMQObjectMessage activeMQObjectMessage = JMSMappingInboundTransformer.createObjectMessage(payload.getArray(), payload.getArrayOffset(), payload.getLength());
            } else if (AmqpMessageSupport.isContentType("application/octet-stream", message)) {
                ActiveMQBytesMessage activeMQBytesMessage = JMSMappingInboundTransformer.createBytesMessage(payload.getArray(), payload.getArrayOffset(), payload.getLength());
            } else {
                Charset charset = AmqpMessageSupport.getCharsetForTextualContent(message.getContentType());
                if (StandardCharsets.UTF_8.equals(charset)) {
                    ByteBuffer buf = ByteBuffer.wrap(payload.getArray(), payload.getArrayOffset(), payload.getLength());
                    try {
                        CharBuffer chars = charset.newDecoder().decode(buf);
                        ActiveMQTextMessage activeMQTextMessage = JMSMappingInboundTransformer.createTextMessage(String.valueOf(chars));
                    }
                    catch (CharacterCodingException e) {
                        ActiveMQBytesMessage activeMQBytesMessage = JMSMappingInboundTransformer.createBytesMessage(payload.getArray(), payload.getArrayOffset(), payload.getLength());
                    }
                } else {
                    ActiveMQBytesMessage activeMQBytesMessage = JMSMappingInboundTransformer.createBytesMessage(payload.getArray(), payload.getArrayOffset(), payload.getLength());
                }
            }
            var4_15.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", (short)2);
            return var4_24;
        } else if (body instanceof AmqpSequence) {
            AmqpSequence sequence = (AmqpSequence)body;
            ActiveMQStreamMessage m = new ActiveMQStreamMessage();
            for (Object item : sequence.getValue()) {
                m.writeObject(item);
            }
            ActiveMQStreamMessage activeMQStreamMessage = m;
            activeMQStreamMessage.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", (short)3);
            return var4_24;
        } else {
            if (!(body instanceof AmqpValue)) throw new RuntimeException("Unexpected body type: " + body.getClass());
            Object value = ((AmqpValue)body).getValue();
            if (value == null || value instanceof String) {
                ActiveMQTextMessage activeMQTextMessage = JMSMappingInboundTransformer.createTextMessage((String)value);
                activeMQTextMessage.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", value == null ? (short)4 : 5);
                return var4_24;
            } else if (value instanceof Binary) {
                void var4_20;
                Binary payload = (Binary)value;
                if (AmqpMessageSupport.isContentType("application/x-java-serialized-object", message)) {
                    ActiveMQObjectMessage activeMQObjectMessage = JMSMappingInboundTransformer.createObjectMessage(payload.getArray(), payload.getArrayOffset(), payload.getLength());
                } else {
                    ActiveMQBytesMessage activeMQBytesMessage = JMSMappingInboundTransformer.createBytesMessage(payload.getArray(), payload.getArrayOffset(), payload.getLength());
                }
                var4_20.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", (short)6);
                return var4_24;
            } else if (value instanceof List) {
                ActiveMQStreamMessage m = new ActiveMQStreamMessage();
                for (Object item : (List)value) {
                    m.writeObject(item);
                }
                ActiveMQStreamMessage activeMQStreamMessage = m;
                activeMQStreamMessage.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", (short)8);
                return var4_24;
            } else {
                if (!(value instanceof Map)) throw new AmqpProtocolException("Unable to encode to ActiveMQ JMS Message", false);
                ActiveMQMapMessage activeMQMapMessage = JMSMappingInboundTransformer.createMapMessage((Map)value);
                activeMQMapMessage.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", (short)7);
            }
        }
        return var4_24;
    }

    private static ActiveMQBytesMessage createBytesMessage(byte[] content, int offset, int length) {
        ActiveMQBytesMessage message = new ActiveMQBytesMessage();
        message.setContent(new ByteSequence(content, offset, length));
        return message;
    }

    public static ActiveMQTextMessage createTextMessage(String text) {
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        try {
            message.setText(text);
        }
        catch (MessageNotWriteableException messageNotWriteableException) {
            // empty catch block
        }
        return message;
    }

    public static ActiveMQObjectMessage createObjectMessage(byte[] content, int offset, int length) {
        ActiveMQObjectMessage message = new ActiveMQObjectMessage();
        message.setContent(new ByteSequence(content, offset, length));
        return message;
    }

    public static ActiveMQMapMessage createMapMessage(Map<String, Object> content) throws JMSException {
        ActiveMQMapMessage message = new ActiveMQMapMessage();
        Set<Map.Entry<String, Object>> set = content.entrySet();
        for (Map.Entry<String, Object> entry : set) {
            Object value = entry.getValue();
            if (value instanceof Binary) {
                Binary binary = (Binary)value;
                value = Arrays.copyOfRange(binary.getArray(), binary.getArrayOffset(), binary.getLength());
            }
            message.setObject(entry.getKey(), value);
        }
        return message;
    }
}

