/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.io.Serializable;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class RollbackRuleAttribute
implements Serializable {
    public static final RollbackRuleAttribute ROLLBACK_ON_RUNTIME_EXCEPTIONS = new RollbackRuleAttribute(RuntimeException.class);
    private final String exceptionPattern;
    @Nullable
    private final Class<? extends Throwable> exceptionType;

    public RollbackRuleAttribute(Class<?> exceptionType) {
        Assert.notNull(exceptionType, "'exceptionType' cannot be null");
        if (!Throwable.class.isAssignableFrom(exceptionType)) {
            throw new IllegalArgumentException("Cannot construct rollback rule from [" + exceptionType.getName() + "]: it's not a Throwable");
        }
        this.exceptionPattern = exceptionType.getName();
        this.exceptionType = exceptionType;
    }

    public RollbackRuleAttribute(String exceptionPattern) {
        Assert.hasText(exceptionPattern, "'exceptionPattern' cannot be null or empty");
        this.exceptionPattern = exceptionPattern;
        this.exceptionType = null;
    }

    public String getExceptionName() {
        return this.exceptionPattern;
    }

    public int getDepth(Throwable exception) {
        return this.getDepth(exception.getClass(), 0);
    }

    private int getDepth(Class<?> exceptionType, int depth) {
        if (this.exceptionType != null ? this.exceptionType.equals(exceptionType) : exceptionType.getName().contains(this.exceptionPattern)) {
            return depth;
        }
        if (exceptionType == Throwable.class) {
            return -1;
        }
        return this.getDepth(exceptionType.getSuperclass(), depth + 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof RollbackRuleAttribute)) return false;
        RollbackRuleAttribute that = (RollbackRuleAttribute)other;
        if (!this.exceptionPattern.equals(that.exceptionPattern)) return false;
        return true;
    }

    public int hashCode() {
        return this.exceptionPattern.hashCode();
    }

    public String toString() {
        return "RollbackRuleAttribute with pattern [" + this.exceptionPattern + "]";
    }
}

