/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc;

import java.io.IOException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.sql.DataSource;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.util.IOExceptionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionContext {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionContext.class);
    private final DataSource dataSource;
    private final JDBCPersistenceAdapter persistenceAdapter;
    private Connection connection;
    private boolean inTx;
    private PreparedStatement addMessageStatement;
    private PreparedStatement removedMessageStatement;
    private PreparedStatement updateLastAckStatement;
    private int transactionIsolation = 1;
    private LinkedList<Runnable> completions = new LinkedList();
    private ReentrantReadWriteLock exclusiveConnectionLock = new ReentrantReadWriteLock();
    private int networkTimeout;
    private int queryTimeout;

    public TransactionContext(JDBCPersistenceAdapter persistenceAdapter, int networkTimeout, int queryTimeout) throws IOException {
        this.persistenceAdapter = persistenceAdapter;
        this.dataSource = persistenceAdapter.getDataSource();
        this.networkTimeout = networkTimeout;
        this.queryTimeout = queryTimeout;
    }

    public Connection getExclusiveConnection() throws IOException {
        return this.lockAndWrapped(this.exclusiveConnectionLock.writeLock());
    }

    public Connection getConnection() throws IOException {
        return this.lockAndWrapped(this.exclusiveConnectionLock.readLock());
    }

    private Connection lockAndWrapped(Lock toLock) throws IOException {
        if (this.connection == null) {
            toLock.lock();
            try {
                this.connection = this.dataSource.getConnection();
                if (this.networkTimeout > 0) {
                    this.connection.setNetworkTimeout(Executors.newSingleThreadExecutor(), this.networkTimeout);
                }
                if (this.persistenceAdapter.isChangeAutoCommitAllowed()) {
                    boolean autoCommit;
                    boolean bl = autoCommit = !this.inTx;
                    if (this.connection.getAutoCommit() != autoCommit) {
                        LOG.trace("Setting auto commit to {} on connection {}", (Object)autoCommit, (Object)this.connection);
                        this.connection.setAutoCommit(autoCommit);
                    }
                }
                this.connection = new UnlockOnCloseConnection(this.connection, toLock);
            }
            catch (SQLException e) {
                JDBCPersistenceAdapter.log("Could not get JDBC connection: ", e);
                this.inTx = false;
                try {
                    toLock.unlock();
                }
                catch (IllegalMonitorStateException oops) {
                    LOG.error("Thread does not hold the context lock on close of:" + this.connection, oops);
                }
                this.silentClose();
                IOException ioe = IOExceptionSupport.create(e);
                if (this.persistenceAdapter.getBrokerService() != null) {
                    this.persistenceAdapter.getBrokerService().handleIOException(ioe);
                }
                throw ioe;
            }
            try {
                this.connection.setTransactionIsolation(this.transactionIsolation);
            }
            catch (Throwable e) {
                LOG.trace("Cannot set transaction isolation to " + this.transactionIsolation + " due " + e.getMessage() + ". This exception is ignored.", e);
            }
        }
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeBatch() throws SQLException {
        try {
            this.executeBatch(this.addMessageStatement, "Failed add a message");
        }
        finally {
            this.addMessageStatement = null;
            try {
                this.executeBatch(this.removedMessageStatement, "Failed to remove a message");
            }
            finally {
                this.removedMessageStatement = null;
                try {
                    this.executeBatch(this.updateLastAckStatement, "Failed to ack a message");
                }
                finally {
                    this.updateLastAckStatement = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeBatch(PreparedStatement p, String message) throws SQLException {
        if (p == null) {
            return;
        }
        try {
            int[] rc = p.executeBatch();
            for (int i2 = 0; i2 < rc.length; ++i2) {
                int code = rc[i2];
                if (code >= 0 || code == -2) continue;
                throw new SQLException(message + ". Response code: " + code);
            }
        }
        finally {
            try {
                p.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private void silentClose() {
        this.silentClosePreparedStatements();
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.connection = null;
        }
    }

    public void close() throws IOException {
        if (!this.inTx) {
            try {
                if (this.connection != null) {
                    boolean needsCommit = !this.connection.getAutoCommit();
                    this.executeBatch();
                    if (needsCommit) {
                        this.connection.commit();
                    }
                }
            }
            catch (SQLException e) {
                JDBCPersistenceAdapter.log("Error while closing connection: ", e);
                IOException ioe = IOExceptionSupport.create(e);
                this.persistenceAdapter.getBrokerService().handleIOException(ioe);
                throw ioe;
            }
            finally {
                this.silentClose();
                for (Runnable completion : this.completions) {
                    completion.run();
                }
                this.completions.clear();
            }
        }
    }

    public void begin() throws IOException {
        if (this.inTx) {
            throw new IOException("Already started.");
        }
        this.inTx = true;
        this.connection = this.getConnection();
    }

    public void commit() throws IOException {
        if (!this.inTx) {
            throw new IOException("Not started.");
        }
        try {
            boolean needsCommit = !this.connection.getAutoCommit();
            this.executeBatch();
            if (needsCommit) {
                this.connection.commit();
            }
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("Commit failed: ", e);
            try {
                this.doRollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            IOException ioe = IOExceptionSupport.create(e);
            this.persistenceAdapter.getBrokerService().handleIOException(ioe);
            throw ioe;
        }
        finally {
            this.inTx = false;
            this.close();
        }
    }

    public void rollback() throws IOException {
        if (!this.inTx) {
            throw new IOException("Not started.");
        }
        try {
            this.doRollback();
        }
        catch (SQLException e) {
            JDBCPersistenceAdapter.log("Rollback failed: ", e);
            throw IOExceptionSupport.create(e);
        }
        finally {
            this.inTx = false;
            this.close();
        }
    }

    private PreparedStatement silentClosePreparedStatement(PreparedStatement preparedStatement) {
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    private void silentClosePreparedStatements() {
        this.addMessageStatement = this.silentClosePreparedStatement(this.addMessageStatement);
        this.removedMessageStatement = this.silentClosePreparedStatement(this.removedMessageStatement);
        this.updateLastAckStatement = this.silentClosePreparedStatement(this.updateLastAckStatement);
    }

    private void doRollback() throws SQLException {
        this.silentClosePreparedStatements();
        this.completions.clear();
        this.connection.rollback();
    }

    public PreparedStatement getAddMessageStatement() {
        return this.addMessageStatement;
    }

    public void setAddMessageStatement(PreparedStatement addMessageStatement) {
        this.addMessageStatement = addMessageStatement;
    }

    public PreparedStatement getUpdateLastAckStatement() {
        return this.updateLastAckStatement;
    }

    public void setUpdateLastAckStatement(PreparedStatement ackMessageStatement) {
        this.updateLastAckStatement = ackMessageStatement;
    }

    public PreparedStatement getRemovedMessageStatement() {
        return this.removedMessageStatement;
    }

    public void setRemovedMessageStatement(PreparedStatement removedMessageStatement) {
        this.removedMessageStatement = removedMessageStatement;
    }

    public void setTransactionIsolation(int transactionIsolation) {
        this.transactionIsolation = transactionIsolation;
    }

    public void onCompletion(Runnable runnable) {
        this.completions.add(runnable);
    }

    private final class UnlockOnCloseConnection
    implements Connection {
        private final Connection delegate;
        private final Lock lock;

        UnlockOnCloseConnection(Connection delegate, Lock toUnlockOnClose) {
            this.delegate = delegate;
            this.lock = toUnlockOnClose;
        }

        @Override
        public void close() throws SQLException {
            try {
                this.delegate.close();
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public Statement createStatement() throws SQLException {
            Statement statement = this.delegate.createStatement();
            if (TransactionContext.this.queryTimeout > 0) {
                statement.setQueryTimeout(TransactionContext.this.queryTimeout);
            }
            return statement;
        }

        @Override
        public PreparedStatement prepareStatement(String sql) throws SQLException {
            PreparedStatement statement = this.delegate.prepareStatement(sql);
            if (TransactionContext.this.queryTimeout > 0) {
                statement.setQueryTimeout(TransactionContext.this.queryTimeout);
            }
            return statement;
        }

        @Override
        public CallableStatement prepareCall(String sql) throws SQLException {
            CallableStatement statement = this.delegate.prepareCall(sql);
            if (TransactionContext.this.queryTimeout > 0) {
                statement.setQueryTimeout(TransactionContext.this.queryTimeout);
            }
            return statement;
        }

        @Override
        public String nativeSQL(String sql) throws SQLException {
            return this.delegate.nativeSQL(sql);
        }

        @Override
        public void setAutoCommit(boolean autoCommit) throws SQLException {
            this.delegate.setAutoCommit(autoCommit);
        }

        @Override
        public boolean getAutoCommit() throws SQLException {
            return this.delegate.getAutoCommit();
        }

        @Override
        public void commit() throws SQLException {
            this.delegate.commit();
        }

        @Override
        public void rollback() throws SQLException {
            this.delegate.rollback();
        }

        @Override
        public boolean isClosed() throws SQLException {
            return this.delegate.isClosed();
        }

        @Override
        public DatabaseMetaData getMetaData() throws SQLException {
            return this.delegate.getMetaData();
        }

        @Override
        public void setReadOnly(boolean readOnly) throws SQLException {
            this.delegate.setReadOnly(readOnly);
        }

        @Override
        public boolean isReadOnly() throws SQLException {
            return this.delegate.isReadOnly();
        }

        @Override
        public void setCatalog(String catalog) throws SQLException {
            this.delegate.setCatalog(catalog);
        }

        @Override
        public String getCatalog() throws SQLException {
            return this.delegate.getCatalog();
        }

        @Override
        public void setTransactionIsolation(int level) throws SQLException {
            this.delegate.setTransactionIsolation(level);
        }

        @Override
        public int getTransactionIsolation() throws SQLException {
            return this.delegate.getTransactionIsolation();
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            return this.delegate.getWarnings();
        }

        @Override
        public void clearWarnings() throws SQLException {
            this.delegate.clearWarnings();
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
            Statement statement = this.delegate.createStatement(resultSetType, resultSetConcurrency);
            if (TransactionContext.this.queryTimeout > 0) {
                statement.setQueryTimeout(TransactionContext.this.queryTimeout);
            }
            return statement;
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            PreparedStatement statement = this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency);
            if (TransactionContext.this.queryTimeout > 0) {
                statement.setQueryTimeout(TransactionContext.this.queryTimeout);
            }
            return statement;
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            CallableStatement statement = this.delegate.prepareCall(sql, resultSetType, resultSetConcurrency);
            if (TransactionContext.this.queryTimeout > 0) {
                statement.setQueryTimeout(TransactionContext.this.queryTimeout);
            }
            return statement;
        }

        @Override
        public Map<String, Class<?>> getTypeMap() throws SQLException {
            return this.delegate.getTypeMap();
        }

        @Override
        public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
            this.delegate.setTypeMap(map);
        }

        @Override
        public void setHoldability(int holdability) throws SQLException {
            this.delegate.setHoldability(holdability);
        }

        @Override
        public int getHoldability() throws SQLException {
            return this.delegate.getHoldability();
        }

        @Override
        public Savepoint setSavepoint() throws SQLException {
            return this.delegate.setSavepoint();
        }

        @Override
        public Savepoint setSavepoint(String name) throws SQLException {
            return this.delegate.setSavepoint(name);
        }

        @Override
        public void rollback(Savepoint savepoint) throws SQLException {
            this.delegate.rollback(savepoint);
        }

        @Override
        public void releaseSavepoint(Savepoint savepoint) throws SQLException {
            this.delegate.releaseSavepoint(savepoint);
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            Statement statement = this.delegate.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
            if (TransactionContext.this.queryTimeout > 0) {
                statement.setQueryTimeout(TransactionContext.this.queryTimeout);
            }
            return statement;
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            PreparedStatement statement = this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            if (TransactionContext.this.queryTimeout > 0) {
                statement.setQueryTimeout(TransactionContext.this.queryTimeout);
            }
            return statement;
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            CallableStatement statement = this.delegate.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            if (TransactionContext.this.queryTimeout > 0) {
                statement.setQueryTimeout(TransactionContext.this.queryTimeout);
            }
            return statement;
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
            PreparedStatement statement = this.delegate.prepareStatement(sql, autoGeneratedKeys);
            if (TransactionContext.this.queryTimeout > 0) {
                statement.setQueryTimeout(TransactionContext.this.queryTimeout);
            }
            return statement;
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
            PreparedStatement statement = this.delegate.prepareStatement(sql, columnIndexes);
            if (TransactionContext.this.queryTimeout > 0) {
                statement.setQueryTimeout(TransactionContext.this.queryTimeout);
            }
            return statement;
        }

        @Override
        public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
            PreparedStatement statement = this.delegate.prepareStatement(sql, columnNames);
            if (TransactionContext.this.queryTimeout > 0) {
                statement.setQueryTimeout(TransactionContext.this.queryTimeout);
            }
            return statement;
        }

        @Override
        public Clob createClob() throws SQLException {
            return this.delegate.createClob();
        }

        @Override
        public Blob createBlob() throws SQLException {
            return this.delegate.createBlob();
        }

        @Override
        public NClob createNClob() throws SQLException {
            return this.delegate.createNClob();
        }

        @Override
        public SQLXML createSQLXML() throws SQLException {
            return this.delegate.createSQLXML();
        }

        @Override
        public boolean isValid(int timeout) throws SQLException {
            return this.delegate.isValid(timeout);
        }

        @Override
        public void setClientInfo(String name, String value) throws SQLClientInfoException {
            this.delegate.setClientInfo(name, value);
        }

        @Override
        public void setClientInfo(Properties properties) throws SQLClientInfoException {
            this.delegate.setClientInfo(properties);
        }

        @Override
        public String getClientInfo(String name) throws SQLException {
            return this.delegate.getClientInfo(name);
        }

        @Override
        public Properties getClientInfo() throws SQLException {
            return this.delegate.getClientInfo();
        }

        @Override
        public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
            return this.delegate.createArrayOf(typeName, elements);
        }

        @Override
        public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
            return this.delegate.createStruct(typeName, attributes);
        }

        @Override
        public void setSchema(String schema) throws SQLException {
            this.delegate.setSchema(schema);
        }

        @Override
        public String getSchema() throws SQLException {
            return this.delegate.getSchema();
        }

        @Override
        public void abort(Executor executor) throws SQLException {
            this.delegate.abort(executor);
        }

        @Override
        public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
            this.delegate.setNetworkTimeout(executor, milliseconds);
        }

        @Override
        public int getNetworkTimeout() throws SQLException {
            return this.delegate.getNetworkTimeout();
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return this.delegate.unwrap(iface);
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return this.delegate.isWrapperFor(iface);
        }
    }
}

