/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire;

public class OpenWireUtil {
    private static final String jmsPackageToReplace = "jakarta.jms";
    private static final String jmsPackageToUse = "javax.jms";

    public static void validateIsThrowable(Class<?> clazz) {
        if (!Throwable.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class " + clazz + " is not assignable to Throwable");
        }
    }

    public static String convertJmsPackage(String className) {
        if (className != null && className.startsWith(jmsPackageToReplace)) {
            return className.replace(jmsPackageToReplace, jmsPackageToUse);
        }
        return className;
    }
}

