/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.command.store;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.activemq.console.command.store.protobuf.MapEntryPB;
import org.apache.activemq.console.command.store.protobuf.MessagePB;
import org.apache.activemq.console.command.store.protobuf.QueueEntryPB;
import org.apache.activemq.console.command.store.protobuf.QueuePB;
import org.apache.activemq.console.command.store.tar.TarEntry;
import org.apache.activemq.console.command.store.tar.TarOutputStream;
import org.apache.activemq.protobuf.AsciiBuffer;
import org.apache.activemq.protobuf.Buffer;
import org.apache.activemq.protobuf.MessageBuffer;

public class BackupStreamManager {
    private final OutputStream target;
    private final int version;
    TarOutputStream stream;
    long seq = 0L;

    BackupStreamManager(OutputStream target, int version) throws IOException {
        this.target = target;
        this.version = version;
        this.stream = new TarOutputStream(new GZIPOutputStream(target));
        this.store("ver", new AsciiBuffer("" + version));
    }

    public void finish() throws IOException {
        this.stream.close();
    }

    private void store(String ext, Buffer value) throws IOException {
        TarEntry entry = new TarEntry(this.seq + "." + ext);
        ++this.seq;
        entry.setSize(value.getLength());
        this.stream.putNextEntry(entry);
        this.stream.write(value.getData());
        this.stream.closeEntry();
    }

    private void store(String ext, MessageBuffer<?, ?> value) throws IOException {
        TarEntry entry = new TarEntry(this.seq + "." + ext);
        ++this.seq;
        entry.setSize(value.serializedSizeFramed());
        this.stream.putNextEntry(entry);
        value.writeFramed(this.stream);
        this.stream.closeEntry();
    }

    public void store_queue(QueuePB value) throws IOException {
        this.store("que", value.toUnframedBuffer());
    }

    public void store_queue_entry(QueueEntryPB value) throws IOException {
        this.store("qen", value.toUnframedBuffer());
    }

    public void store_message(MessagePB value) throws IOException {
        this.store("msg", value.toUnframedBuffer());
    }

    public void store_map_entry(MapEntryPB value) throws IOException {
        this.store("map", value.toUnframedBuffer());
    }
}

