/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.loadbalancer;

import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.processor.loadbalancer.QueueLoadBalancer;

public class RoundRobinLoadBalancer
extends QueueLoadBalancer {
    private int counter = -1;

    @Override
    protected synchronized Processor chooseProcessor(List<Processor> processors, Exchange exchange) {
        int size2 = processors.size();
        if (++this.counter >= size2) {
            this.counter = 0;
        }
        return processors.get(this.counter);
    }

    public int getLastChosenProcessorIndex() {
        return this.counter;
    }

    public String toString() {
        return "RoundRobinLoadBalancer";
    }
}

