/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.cloud;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.cloud.ServiceLoadBalancer;
import org.apache.camel.processor.SendDynamicProcessor;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServiceCallProcessor
extends ServiceSupport
implements AsyncProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultServiceCallProcessor.class);
    private final ExchangePattern exchangePattern;
    private final String name;
    private final String scheme;
    private final String uri;
    private final String contextPath;
    private final CamelContext camelContext;
    private final ServiceLoadBalancer loadBalancer;
    private final Expression expression;
    private SendDynamicProcessor processor;

    public DefaultServiceCallProcessor(CamelContext camelContext, String name, String scheme, String uri, ExchangePattern exchangePattern, ServiceLoadBalancer loadBalancer, Expression expression) {
        String serviceName;
        this.uri = uri;
        this.exchangePattern = exchangePattern;
        this.camelContext = camelContext;
        this.loadBalancer = loadBalancer;
        if (name.contains("/")) {
            serviceName = StringHelper.before(name, "/");
            this.contextPath = StringHelper.after(name, "/");
        } else if (name.contains("?")) {
            serviceName = StringHelper.before(name, "?");
            this.contextPath = StringHelper.after(name, "?");
        } else {
            serviceName = name;
            this.contextPath = null;
        }
        if (serviceName.contains(":")) {
            this.scheme = StringHelper.before(serviceName, ":");
            this.name = StringHelper.after(serviceName, ":");
        } else {
            this.scheme = scheme;
            this.name = serviceName;
        }
        this.expression = expression;
    }

    public ExchangePattern getExchangePattern() {
        return this.exchangePattern;
    }

    public String getName() {
        return this.name;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getUri() {
        return this.uri;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public ServiceLoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    protected void doStart() throws Exception {
        StringHelper.notEmpty(this.name, "name", "service name");
        ObjectHelper.notNull(this.camelContext, "camel context");
        ObjectHelper.notNull(this.expression, "expression");
        ObjectHelper.notNull(this.loadBalancer, "load balancer");
        this.processor = new SendDynamicProcessor(this.uri, this.expression);
        this.processor.setCamelContext(this.camelContext);
        if (this.exchangePattern != null) {
            this.processor.setPattern(this.exchangePattern);
        }
        ServiceHelper.startService(this.processor);
        ServiceHelper.startService(this.loadBalancer);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.loadBalancer);
        ServiceHelper.stopService(this.processor);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        Message message = exchange.getIn();
        message.setHeader("CamelServiceCallUri", this.uri);
        message.setHeader("CamelServiceCallContextPath", this.contextPath);
        message.setHeader("CamelServiceCallScheme", this.scheme);
        String serviceName = message.getHeader("CamelServiceCallServiceName", this.name, String.class);
        try {
            return this.loadBalancer.process(serviceName, (ServiceDefinition server) -> this.execute(server, exchange, callback));
        }
        catch (Exception e) {
            exchange.setException(e);
            return true;
        }
    }

    private boolean execute(ServiceDefinition server, Exchange exchange, AsyncCallback callback) throws Exception {
        String host = server.getHost();
        int port = server.getPort();
        LOGGER.debug("Service {} active at server: {}:{}", this.name, host, port);
        exchange.getIn().setHeader("CamelServiceCallServiceHost", host);
        exchange.getIn().setHeader("CamelServiceCallServicePort", port > 0 ? Integer.valueOf(port) : null);
        exchange.getIn().setHeader("CamelServiceCallServiceName", server.getName());
        exchange.getIn().setHeader("CamelServiceCallServiceMeta", server.getMetadata());
        return this.processor.process(exchange, callback);
    }
}

