/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.impl.DefaultCamelBeanPostProcessor;
import org.apache.camel.spi.Injector;
import org.apache.camel.util.ReflectionInjector;

public class DefaultInjector
implements Injector {
    private final Injector delegate = new ReflectionInjector();
    private final DefaultCamelBeanPostProcessor postProcessor;

    public DefaultInjector(CamelContext context) {
        this.postProcessor = new DefaultCamelBeanPostProcessor(context);
    }

    @Override
    public <T> T newInstance(Class<T> type) {
        T answer = this.delegate.newInstance(type);
        if (answer != null) {
            try {
                this.postProcessor.postProcessBeforeInitialization(answer, answer.getClass().getName());
                this.postProcessor.postProcessAfterInitialization(answer, answer.getClass().getName());
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Error during post processing of bean " + answer, e);
            }
        }
        return answer;
    }

    @Override
    public <T> T newInstance(Class<T> type, Object instance) {
        T answer = this.delegate.newInstance(type, instance);
        if (answer != null) {
            try {
                this.postProcessor.postProcessBeforeInitialization(answer, answer.getClass().getName());
                this.postProcessor.postProcessAfterInitialization(answer, answer.getClass().getName());
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Error during post processing of bean " + answer, e);
            }
        }
        return answer;
    }
}

