/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.time.Duration;
import org.apache.camel.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter
public final class DurationConverter {
    private static final Logger LOG = LoggerFactory.getLogger(DurationConverter.class);

    private DurationConverter() {
    }

    @Converter
    public static long toMilliSeconds(Duration source) {
        long milliseconds = source.toMillis();
        LOG.trace("source: {} milliseconds: ", (Object)source, (Object)milliseconds);
        return milliseconds;
    }

    @Converter
    public static Duration fromString(String source) {
        Duration duration = Duration.parse(source);
        LOG.trace("source: {} milliseconds: ", (Object)source, (Object)duration);
        return duration;
    }

    @Converter
    public static String asString(Duration source) {
        String result = source.toString();
        LOG.trace("source: {} milliseconds: ", (Object)source, (Object)result);
        return result;
    }
}

