/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.camel.NonManagedService;
import org.apache.camel.StaticService;
import org.apache.camel.impl.scan.AnnotatedWithAnyPackageScanFilter;
import org.apache.camel.impl.scan.AnnotatedWithPackageScanFilter;
import org.apache.camel.impl.scan.AssignableToPackageScanFilter;
import org.apache.camel.impl.scan.CompositePackageScanFilter;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.PackageScanFilter;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.LRUCacheFactory;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPackageScanClassResolver
extends ServiceSupport
implements PackageScanClassResolver,
StaticService,
NonManagedService {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Set<ClassLoader> classLoaders = new LinkedHashSet<ClassLoader>();
    private Map<String, List<String>> jarCache;
    private Set<PackageScanFilter> scanFilters;
    private String[] acceptableSchemes = new String[0];

    public DefaultPackageScanClassResolver() {
        try {
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            if (ccl != null) {
                this.log.trace("Adding ContextClassLoader from current thread: {}", (Object)ccl);
                this.classLoaders.add(ccl);
            }
        }
        catch (Exception e) {
            this.log.warn("Cannot add ContextClassLoader from current thread due {}. This exception will be ignored.", (Object)e.getMessage());
        }
        this.classLoaders.add(DefaultPackageScanClassResolver.class.getClassLoader());
    }

    @Override
    public void addClassLoader(ClassLoader classLoader) {
        this.classLoaders.add(classLoader);
    }

    @Override
    public void addFilter(PackageScanFilter filter) {
        if (this.scanFilters == null) {
            this.scanFilters = new LinkedHashSet<PackageScanFilter>();
        }
        this.scanFilters.add(filter);
    }

    @Override
    public void removeFilter(PackageScanFilter filter) {
        if (this.scanFilters != null) {
            this.scanFilters.remove(filter);
        }
    }

    public void setAcceptableSchemes(String schemes) {
        if (schemes != null) {
            this.acceptableSchemes = schemes.split(";");
        }
    }

    public boolean isAcceptableScheme(String urlPath) {
        if (urlPath != null) {
            for (String scheme : this.acceptableSchemes) {
                if (!urlPath.startsWith(scheme)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<ClassLoader> getClassLoaders() {
        return Collections.unmodifiableSet(new LinkedHashSet<ClassLoader>(this.classLoaders));
    }

    @Override
    public void setClassLoaders(Set<ClassLoader> classLoaders) {
        this.classLoaders.addAll(classLoaders);
    }

    @Override
    public Set<Class<?>> findAnnotated(Class<? extends Annotation> annotation, String ... packageNames) {
        if (packageNames == null) {
            return Collections.emptySet();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Searching for annotations of {} in packages: {}", (Object)annotation.getName(), (Object)Arrays.asList(packageNames));
        }
        PackageScanFilter test = this.getCompositeFilter(new AnnotatedWithPackageScanFilter(annotation, true));
        LinkedHashSet classes = new LinkedHashSet();
        for (String pkg : packageNames) {
            this.find(test, pkg, classes);
        }
        this.log.debug("Found: {}", (Object)classes);
        return classes;
    }

    @Override
    public Set<Class<?>> findAnnotated(Set<Class<? extends Annotation>> annotations, String ... packageNames) {
        if (packageNames == null) {
            return Collections.emptySet();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Searching for annotations of {} in packages: {}", (Object)annotations, (Object)Arrays.asList(packageNames));
        }
        PackageScanFilter test = this.getCompositeFilter(new AnnotatedWithAnyPackageScanFilter(annotations, true));
        LinkedHashSet classes = new LinkedHashSet();
        for (String pkg : packageNames) {
            this.find(test, pkg, classes);
        }
        this.log.debug("Found: {}", (Object)classes);
        return classes;
    }

    @Override
    public Set<Class<?>> findImplementations(Class<?> parent, String ... packageNames) {
        if (packageNames == null) {
            return Collections.emptySet();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Searching for implementations of {} in packages: {}", (Object)parent.getName(), (Object)Arrays.asList(packageNames));
        }
        PackageScanFilter test = this.getCompositeFilter(new AssignableToPackageScanFilter(parent));
        LinkedHashSet classes = new LinkedHashSet();
        for (String pkg : packageNames) {
            this.find(test, pkg, classes);
        }
        this.log.debug("Found: {}", (Object)classes);
        return classes;
    }

    @Override
    public Set<Class<?>> findByFilter(PackageScanFilter filter, String ... packageNames) {
        if (packageNames == null) {
            return Collections.emptySet();
        }
        LinkedHashSet classes = new LinkedHashSet();
        for (String pkg : packageNames) {
            this.find(filter, pkg, classes);
        }
        this.log.debug("Found: {}", (Object)classes);
        return classes;
    }

    protected void find(PackageScanFilter test, String packageName, Set<Class<?>> classes) {
        packageName = packageName.replace('.', '/');
        Set<ClassLoader> set = this.getClassLoaders();
        for (ClassLoader classLoader : set) {
            this.find(test, packageName, classLoader, classes);
        }
    }

    protected void find(PackageScanFilter test, String packageName, ClassLoader loader, Set<Class<?>> classes) {
        Enumeration<URL> urls;
        if (this.log.isTraceEnabled()) {
            this.log.trace("Searching for: {} in package: {} using classloader: {}", test, packageName, loader.getClass().getName());
        }
        try {
            urls = this.getResources(loader, packageName);
            if (!urls.hasMoreElements()) {
                this.log.trace("No URLs returned by classloader");
            }
        }
        catch (IOException ioe) {
            this.log.warn("Cannot read package: {}", (Object)packageName, (Object)ioe);
            return;
        }
        while (urls.hasMoreElements()) {
            URL url = null;
            try {
                InputStream stream;
                url = urls.nextElement();
                this.log.trace("URL from classloader: {}", (Object)url);
                url = this.customResourceLocator(url);
                String urlPath = url.getFile();
                urlPath = URLDecoder.decode(urlPath, "UTF-8");
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Decoded urlPath: {} with protocol: {}", (Object)urlPath, (Object)url.getProtocol());
                }
                if (urlPath.startsWith("file:")) {
                    try {
                        urlPath = new URI(url.getFile()).getPath();
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                    if (urlPath.startsWith("file:")) {
                        urlPath = urlPath.substring(5);
                    }
                }
                if (url.toString().startsWith("bundle:") || urlPath.startsWith("bundle:")) {
                    this.log.trace("Skipping OSGi bundle: {}", (Object)url);
                    continue;
                }
                if (url.toString().startsWith("bundleresource:") || urlPath.startsWith("bundleresource:")) {
                    this.log.trace("Skipping bundleresource: {}", (Object)url);
                    continue;
                }
                if (urlPath.indexOf(33) > 0) {
                    urlPath = urlPath.substring(0, urlPath.indexOf(33));
                }
                this.log.trace("Scanning for classes in: {} matching criteria: {}", (Object)urlPath, (Object)test);
                File file = new File(urlPath);
                if (file.isDirectory()) {
                    this.log.trace("Loading from directory using file: {}", (Object)file);
                    this.loadImplementationsInDirectory(test, packageName, file, classes);
                    continue;
                }
                if (urlPath.startsWith("http:") || urlPath.startsWith("https:") || urlPath.startsWith("sonicfs:") || this.isAcceptableScheme(urlPath)) {
                    this.log.trace("Loading from jar using url: {}", (Object)urlPath);
                    URL urlStream = new URL(urlPath);
                    URLConnection con = urlStream.openConnection();
                    con.setUseCaches(false);
                    stream = con.getInputStream();
                } else {
                    this.log.trace("Loading from jar using file: {}", (Object)file);
                    stream = new FileInputStream(file);
                }
                this.loadImplementationsInJar(test, packageName, stream, urlPath, classes, this.jarCache);
            }
            catch (IOException e) {
                this.log.debug("Cannot read entries in url: {}", (Object)url, (Object)e);
            }
        }
    }

    protected URL customResourceLocator(URL url) throws IOException {
        return url;
    }

    protected Enumeration<URL> getResources(ClassLoader loader, String packageName) throws IOException {
        this.log.trace("Getting resource URL for package: {} with classloader: {}", (Object)packageName, (Object)loader);
        if (!packageName.endsWith("/")) {
            packageName = packageName + "/";
        }
        return loader.getResources(packageName);
    }

    private PackageScanFilter getCompositeFilter(PackageScanFilter filter) {
        if (this.scanFilters != null) {
            CompositePackageScanFilter composite = new CompositePackageScanFilter(this.scanFilters);
            composite.addFilter(filter);
            return composite;
        }
        return filter;
    }

    private void loadImplementationsInDirectory(PackageScanFilter test, String parent, File location, Set<Class<?>> classes) {
        File[] files;
        for (File file : files = location.listFiles()) {
            String packageOrClass;
            StringBuilder builder = new StringBuilder(100);
            String name = file.getName();
            if (name == null) continue;
            name = name.trim();
            builder.append(parent).append("/").append(name);
            String string = packageOrClass = parent == null ? name : builder.toString();
            if (file.isDirectory()) {
                this.loadImplementationsInDirectory(test, packageOrClass, file, classes);
                continue;
            }
            if (!name.endsWith(".class")) continue;
            this.addIfMatching(test, packageOrClass, classes);
        }
    }

    private void loadImplementationsInJar(PackageScanFilter test, String parent, InputStream stream, String urlPath, Set<Class<?>> classes, Map<String, List<String>> jarCache) {
        List<String> entries;
        ObjectHelper.notNull(classes, "classes");
        List<String> list = entries = jarCache != null ? jarCache.get(urlPath) : null;
        if (entries == null) {
            entries = this.doLoadJarClassEntries(stream, urlPath);
            if (jarCache != null) {
                jarCache.put(urlPath, entries);
                this.log.trace("Cached {} JAR with {} entries", (Object)urlPath, (Object)entries.size());
            }
        } else {
            this.log.trace("Using cached {} JAR with {} entries", (Object)urlPath, (Object)entries.size());
        }
        this.doLoadImplementationsInJar(test, parent, entries, classes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> doLoadJarClassEntries(InputStream stream, String urlPath) {
        ArrayList<String> entries = new ArrayList<String>();
        JarInputStream jarStream = null;
        try {
            JarEntry entry;
            jarStream = new JarInputStream(stream);
            while ((entry = jarStream.getNextJarEntry()) != null) {
                String name = entry.getName();
                if (name == null) continue;
                name = name.trim();
                if (entry.isDirectory() || !name.endsWith(".class")) continue;
                entries.add(name);
            }
        }
        catch (IOException ioe) {
            this.log.warn("Cannot search jar file '" + urlPath + " due to an IOException: " + ioe.getMessage(), ioe);
        }
        finally {
            IOHelper.close((Closeable)jarStream, urlPath, this.log);
        }
        return entries;
    }

    private void doLoadImplementationsInJar(PackageScanFilter test, String parent, List<String> entries, Set<Class<?>> classes) {
        for (String entry : entries) {
            if (!entry.startsWith(parent)) continue;
            this.addIfMatching(test, entry, classes);
        }
    }

    protected void addIfMatching(PackageScanFilter test, String fqn, Set<Class<?>> classes) {
        block9: {
            try {
                String externalName = fqn.substring(0, fqn.indexOf(46)).replace('/', '.');
                Set<ClassLoader> set = this.getClassLoaders();
                boolean found = false;
                for (ClassLoader classLoader : set) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("Testing for class {} matches criteria [{}] using classloader: {}", externalName, test, classLoader);
                    }
                    try {
                        Class<?> type = classLoader.loadClass(externalName);
                        this.log.trace("Loaded the class: {} in classloader: {}", (Object)type, (Object)classLoader);
                        if (test.matches(type)) {
                            this.log.trace("Found class: {} which matches the filter in classloader: {}", (Object)type, (Object)classLoader);
                            classes.add(type);
                        }
                        found = true;
                        break;
                    }
                    catch (ClassNotFoundException e) {
                        if (!this.log.isTraceEnabled()) continue;
                        this.log.trace("Cannot find class '" + fqn + "' in classloader: " + classLoader + ". Reason: " + e.getMessage(), e);
                    }
                    catch (NoClassDefFoundError e) {
                        if (!this.log.isTraceEnabled()) continue;
                        this.log.trace("Cannot find the class definition '" + fqn + "' in classloader: " + classLoader + ". Reason: " + e.getMessage(), e);
                    }
                }
                if (!found) {
                    this.log.debug("Cannot find class '{}' in any classloaders: {}", (Object)fqn, (Object)set);
                }
            }
            catch (Exception e) {
                if (!this.log.isWarnEnabled()) break block9;
                this.log.warn("Cannot examine class '" + fqn + "' due to a " + e.getClass().getName() + " with message: " + e.getMessage(), e);
            }
        }
    }

    @Override
    protected void doStart() throws Exception {
        if (this.jarCache == null) {
            this.jarCache = LRUCacheFactory.newLRUCache(1000);
        }
    }

    @Override
    protected void doStop() throws Exception {
        this.jarCache.clear();
    }
}

