/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.command;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.activemq.console.command.AbstractCommand;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class CreateCommand
extends AbstractCommand {
    protected final String[] helpFile = new String[]{"Task Usage: Main create path/to/brokerA [create-options]", "Description:  Creates a runnable broker instance in the specified path.", "", "List Options:", "    --amqconf <file path>   Path to ActiveMQ conf file that will be used in the broker instance. Default is: conf/activemq.xml", "    --version               Display the version information.", "    -h,-?,--help            Display the create broker help information.", ""};
    protected final String DEFAULT_TARGET_ACTIVEMQ_CONF = "conf/activemq.xml";
    protected final String DEFAULT_BROKERNAME_XPATH = "/beans/broker/@brokerName";
    protected final String[] BASE_SUB_DIRS = new String[]{"bin", "conf"};
    protected final String BROKER_NAME_REGEX = "[$][{]brokerName[}]";
    protected String amqConf = "conf/activemq.xml";
    protected String[][] fileWriteMap = new String[][]{{"winActivemq", "bin/${brokerName}.bat"}, {"unixActivemq", "bin/${brokerName}"}};
    protected String brokerName;
    protected File amqHome;
    protected File targetAmqBase;
    private static final String winActivemqData = "@echo off\nset ACTIVEMQ_HOME=\"${activemq.home}\"\nset ACTIVEMQ_BASE=\"${activemq.base}\"\n\nset PARAM=%1\n:getParam\nshift\nif \"%1\"==\"\" goto end\nset PARAM=%PARAM% %1\ngoto getParam\n:end\n\n%ACTIVEMQ_HOME%/bin/activemq %PARAM%";

    @Override
    public String getName() {
        return "create";
    }

    @Override
    public String getOneLineDescription() {
        return "Creates a runnable broker instance in the specified path.";
    }

    @Override
    protected void runTask(List<String> tokens) throws Exception {
        this.context.print("Running create broker task...");
        this.amqHome = new File(System.getProperty("activemq.home"));
        for (String token : tokens) {
            block3: {
                this.targetAmqBase = new File(token);
                this.brokerName = this.targetAmqBase.getName();
                if (this.targetAmqBase.exists()) {
                    String resp;
                    BufferedReader console = new BufferedReader(new InputStreamReader(System.in));
                    do {
                        this.context.print("Target directory (" + this.targetAmqBase.getCanonicalPath() + ") already exists. Overwrite (y/n): ");
                        resp = console.readLine();
                        if (resp.equalsIgnoreCase("y") || resp.equalsIgnoreCase("yes")) break block3;
                    } while (!resp.equalsIgnoreCase("n") && !resp.equalsIgnoreCase("no"));
                    return;
                }
            }
            this.context.print("Creating directory: " + this.targetAmqBase.getCanonicalPath());
            this.targetAmqBase.mkdirs();
            this.createSubDirs(this.targetAmqBase, this.BASE_SUB_DIRS);
            this.writeFileMapping(this.targetAmqBase, this.fileWriteMap);
            this.copyActivemqConf(this.amqHome, this.targetAmqBase, this.amqConf);
            this.copyConfDirectory(new File(this.amqHome, "conf"), new File(this.targetAmqBase, "conf"));
        }
    }

    @Override
    protected void handleOption(String token, List<String> tokens) throws Exception {
        if (token.startsWith("--amqconf")) {
            if (tokens.isEmpty() || tokens.get(0).startsWith("-")) {
                this.context.printException(new IllegalArgumentException("Attributes to amqconf not specified"));
                return;
            }
            this.amqConf = tokens.remove(0);
        } else {
            super.handleOption(token, tokens);
        }
    }

    protected void createSubDirs(File target, String[] subDirs) throws IOException {
        for (String subDir : this.BASE_SUB_DIRS) {
            File subDirFile = new File(target, subDir);
            this.context.print("Creating directory: " + subDirFile.getCanonicalPath());
            subDirFile.mkdirs();
        }
    }

    protected void writeFileMapping(File targetBase, String[][] fileWriteMapping) throws IOException {
        for (String[] fileWrite : fileWriteMapping) {
            File dest = new File(targetBase, this.resolveParam("[$][{]brokerName[}]", this.brokerName, fileWrite[1]));
            this.context.print("Creating new file: " + dest.getCanonicalPath());
            this.writeFile(fileWrite[0], dest);
        }
    }

    protected void copyActivemqConf(File srcBase, File targetBase, String activemqConf) throws IOException, ParserConfigurationException, SAXException, TransformerException, XPathExpressionException {
        File src = new File(srcBase, activemqConf);
        if (!src.exists()) {
            throw new FileNotFoundException("File: " + src.getCanonicalPath() + " not found.");
        }
        File dest = new File(targetBase, "conf/activemq.xml");
        this.context.print("Copying from: " + src.getCanonicalPath() + "\n          to: " + dest.getCanonicalPath());
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Element docElem = builder.parse(src).getDocumentElement();
        XPath xpath = XPathFactory.newInstance().newXPath();
        Attr brokerNameAttr = (Attr)xpath.evaluate("/beans/broker/@brokerName", docElem, XPathConstants.NODE);
        brokerNameAttr.setValue(this.brokerName);
        this.writeToFile(new DOMSource(docElem), dest);
    }

    @Override
    protected void printHelp() {
        this.context.printHelp(this.helpFile);
    }

    private void writeFile(String typeName, File dest) throws IOException {
        String data;
        if (typeName.equals("winActivemq")) {
            data = winActivemqData;
            data = this.resolveParam("[$][{]activemq.home[}]", this.amqHome.getCanonicalPath().replaceAll("[\\\\]", "/"), data);
            data = this.resolveParam("[$][{]activemq.base[}]", this.targetAmqBase.getCanonicalPath().replaceAll("[\\\\]", "/"), data);
        } else if (typeName.equals("unixActivemq")) {
            data = this.getUnixActivemqData();
            data = this.resolveParam("[$][{]activemq.home[}]", this.amqHome.getCanonicalPath().replaceAll("[\\\\]", "/"), data);
            data = this.resolveParam("[$][{]activemq.base[}]", this.targetAmqBase.getCanonicalPath().replaceAll("[\\\\]", "/"), data);
        } else {
            throw new IllegalStateException("Unknown file type: " + typeName);
        }
        ByteBuffer buf = ByteBuffer.allocate(data.length());
        buf.put(data.getBytes());
        buf.flip();
        try (FileOutputStream fos = new FileOutputStream(dest);
             FileChannel destinationChannel = fos.getChannel();){
            destinationChannel.write(buf);
        }
        dest.setExecutable(true);
        dest.setReadable(true);
        dest.setWritable(true);
    }

    private void writeToFile(Source src, File file) throws TransformerException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        tFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        Transformer fileTransformer = tFactory.newTransformer();
        StreamResult res = new StreamResult(file);
        fileTransformer.transform(src, res);
    }

    private void copyFile(File from, File dest) throws IOException {
        if (!from.exists()) {
            return;
        }
        try (FileInputStream fis = new FileInputStream(from);
             FileChannel sourceChannel = fis.getChannel();
             FileOutputStream fos = new FileOutputStream(dest);
             FileChannel destinationChannel = fos.getChannel();){
            sourceChannel.transferTo(0L, sourceChannel.size(), destinationChannel);
        }
    }

    private void copyConfDirectory(File from, File dest) throws IOException {
        if (from.isDirectory()) {
            String[] files;
            for (String file : files = from.list()) {
                File srcFile = new File(from, file);
                if (!srcFile.isFile() || srcFile.getName().equals("activemq.xml")) continue;
                File destFile = new File(dest, file);
                this.context.print("Copying from: " + srcFile.getCanonicalPath() + "\n          to: " + destFile.getCanonicalPath());
                this.copyFile(srcFile, destFile);
            }
        } else {
            throw new IOException(from + " is not a directory");
        }
    }

    private String resolveParam(String paramName, String paramValue, String target) {
        return target.replaceAll(paramName, paramValue);
    }

    private String getUnixActivemqData() {
        StringBuffer res = new StringBuffer();
        res.append("!/bin/sh\n\n");
        res.append("## Figure out the ACTIVEMQ_BASE from the directory this script was run from\n");
        res.append("PRG=\"$0\"\n");
        res.append("progname=`basename \"$0\"`\n");
        res.append("saveddir=`pwd`\n");
        res.append("# need this for relative symlinks\n");
        res.append("dirname_prg=`dirname \"$PRG\"`\n");
        res.append("cd \"$dirname_prg\"\n");
        res.append("while [ -h \"$PRG\" ] ; do\n");
        res.append("  ls=`ls -ld \"$PRG\"`\n");
        res.append("  link=`expr \"$ls\" : '.*-> \\(.*\\)$'`\n");
        res.append("  if expr \"$link\" : '.*/.*' > /dev/null; then\n");
        res.append("    PRG=\"$link\"\n");
        res.append("  else\n");
        res.append("    PRG=`dirname \"$PRG\"`\"/$link\"\n");
        res.append("  fi\n");
        res.append("done\n");
        res.append("ACTIVEMQ_BASE=`dirname \"$PRG\"`/..\n");
        res.append("cd \"$saveddir\"\n\n");
        res.append("ACTIVEMQ_BASE=`cd \"$ACTIVEMQ_BASE\" && pwd`\n\n");
        res.append("## Enable remote debugging\n");
        res.append("#export ACTIVEMQ_DEBUG_OPTS=\"-Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=5005\"\n\n");
        res.append("## Add system properties for this instance here (if needed), e.g\n");
        res.append("#export ACTIVEMQ_OPTS_MEMORY=\"-Xms256M -Xmx1G\"\n");
        res.append("#export ACTIVEMQ_OPTS=\"$ACTIVEMQ_OPTS_MEMORY -Dorg.apache.activemq.UseDedicatedTaskRunner=true -Djava.util.logging.config.file=logging.properties\"\n\n");
        res.append("export ACTIVEMQ_HOME=${activemq.home}\n");
        res.append("export ACTIVEMQ_BASE=$ACTIVEMQ_BASE\n\n");
        res.append("${ACTIVEMQ_HOME}/bin/activemq \"$@\"");
        return res.toString();
    }
}

