/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.fate.zookeeper;

import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.accumulo.fate.zookeeper.DistributedReadWriteLock;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.zookeeper.KeeperException;

public class ZooQueueLock
implements DistributedReadWriteLock.QueueLock {
    private static final String PREFIX = "lock-";
    private IZooReaderWriter zoo;
    private String path;
    private boolean ephemeral;

    public ZooQueueLock(String zookeepers, int timeInMillis, String scheme, byte[] auth, String path, boolean ephemeral) throws KeeperException, InterruptedException {
        this(ZooReaderWriter.getInstance(zookeepers, timeInMillis, scheme, auth), path, ephemeral);
    }

    protected ZooQueueLock(IZooReaderWriter zrw, String path, boolean ephemeral) {
        this.zoo = zrw;
        this.path = path;
        this.ephemeral = ephemeral;
    }

    @Override
    public long addEntry(byte[] data) {
        try {
            while (true) {
                try {
                    String newPath = this.ephemeral ? this.zoo.putEphemeralSequential(this.path + "/" + PREFIX, data) : this.zoo.putPersistentSequential(this.path + "/" + PREFIX, data);
                    String[] parts = newPath.split("/");
                    String last = parts[parts.length - 1];
                    return Long.parseLong(last.substring(PREFIX.length()));
                }
                catch (KeeperException.NoNodeException nne) {
                    this.zoo.putPersistentData(this.path, new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public SortedMap<Long, byte[]> getEarlierEntries(long entry) {
        TreeMap<Long, byte[]> result = new TreeMap<Long, byte[]>();
        try {
            List<Object> children = Collections.emptyList();
            try {
                children = this.zoo.getChildren(this.path);
            }
            catch (KeeperException.NoNodeException ex) {
                // empty catch block
            }
            for (String name : children) {
                try {
                    byte[] data = this.zoo.getData(this.path + "/" + name, null);
                    long order = Long.parseLong(name.substring(PREFIX.length()));
                    if (order > entry) continue;
                    result.put(order, data);
                }
                catch (KeeperException.NoNodeException ex) {}
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return result;
    }

    @Override
    public void removeEntry(long entry) {
        try {
            this.zoo.recursiveDelete(this.path + String.format("/%s%010d", PREFIX, entry), ZooUtil.NodeMissingPolicy.SKIP);
            try {
                this.zoo.delete(this.path, -1);
            }
            catch (KeeperException.NotEmptyException nee) {
            }
            catch (KeeperException.NoNodeException nne) {}
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

