/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.fate.zookeeper;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.accumulo.fate.zookeeper.ZooCacheFactory;
import org.apache.accumulo.fate.zookeeper.ZooReader;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class ZooCache {
    private static final Logger log = Logger.getLogger(ZooCache.class);
    private ZCacheWatcher watcher = new ZCacheWatcher();
    private Watcher externalWatcher = null;
    private HashMap<String, byte[]> cache;
    private HashMap<String, Stat> statCache;
    private HashMap<String, List<String>> childrenCache;
    private ZooReader zReader;
    private static ZooCacheFactory zcf = new ZooCacheFactory();

    private ZooKeeper getZooKeeper() {
        return this.zReader.getZooKeeper();
    }

    public ZooCache(String zooKeepers, int sessionTimeout) {
        this(zooKeepers, sessionTimeout, null);
    }

    public ZooCache(String zooKeepers, int sessionTimeout, Watcher watcher) {
        this(new ZooReader(zooKeepers, sessionTimeout), watcher);
    }

    public ZooCache(ZooReader reader, Watcher watcher) {
        this.zReader = reader;
        this.cache = new HashMap();
        this.statCache = new HashMap();
        this.childrenCache = new HashMap();
        this.externalWatcher = watcher;
    }

    private synchronized void retry(ZooRunnable op) {
        int sleepTime = 100;
        while (true) {
            ZooKeeper zooKeeper = this.getZooKeeper();
            try {
                op.run(zooKeeper);
                return;
            }
            catch (KeeperException e) {
                KeeperException.Code code = e.code();
                if (code == KeeperException.Code.NONODE) {
                    log.error((Object)("Looked up non-existent node in cache " + e.getPath()), (Throwable)e);
                } else if (code == KeeperException.Code.CONNECTIONLOSS || code == KeeperException.Code.OPERATIONTIMEOUT || code == KeeperException.Code.SESSIONEXPIRED) {
                    log.warn((Object)"Saw (possibly) transient exception communicating with ZooKeeper, will retry", (Throwable)e);
                } else {
                    log.warn((Object)"Zookeeper error, will retry", (Throwable)e);
                }
            }
            catch (InterruptedException e) {
                log.info((Object)"Zookeeper error, will retry", (Throwable)e);
            }
            catch (ConcurrentModificationException e) {
                log.debug((Object)"Zookeeper was modified, will retry");
            }
            try {
                this.wait(sleepTime);
            }
            catch (InterruptedException e) {
                log.info((Object)"Interrupted waiting before retrying ZooKeeper operation", (Throwable)e);
            }
            if (sleepTime >= 10000) continue;
            sleepTime = (int)((double)sleepTime + (double)sleepTime * Math.random());
        }
    }

    public synchronized List<String> getChildren(final String zPath) {
        ZooRunnable zr = new ZooRunnable(){

            @Override
            public void run(ZooKeeper zooKeeper) throws KeeperException, InterruptedException {
                block3: {
                    if (ZooCache.this.childrenCache.containsKey(zPath)) {
                        return;
                    }
                    try {
                        List children = zooKeeper.getChildren(zPath, (Watcher)ZooCache.this.watcher);
                        ZooCache.this.childrenCache.put(zPath, children);
                    }
                    catch (KeeperException ke) {
                        if (ke.code() == KeeperException.Code.NONODE) break block3;
                        throw ke;
                    }
                }
            }
        };
        this.retry(zr);
        List<String> children = this.childrenCache.get(zPath);
        if (children == null) {
            return null;
        }
        return Collections.unmodifiableList(children);
    }

    public synchronized byte[] get(String zPath) {
        return this.get(zPath, null);
    }

    public synchronized byte[] get(final String zPath, Stat stat) {
        Stat cstat;
        ZooRunnable zr = new ZooRunnable(){

            @Override
            public void run(ZooKeeper zooKeeper) throws KeeperException, InterruptedException {
                if (ZooCache.this.cache.containsKey(zPath)) {
                    return;
                }
                Stat stat = zooKeeper.exists(zPath, (Watcher)ZooCache.this.watcher);
                byte[] data = null;
                if (stat == null) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("zookeeper did not contain " + zPath));
                    }
                } else {
                    try {
                        data = zooKeeper.getData(zPath, (Watcher)ZooCache.this.watcher, stat);
                    }
                    catch (KeeperException.BadVersionException e1) {
                        throw new ConcurrentModificationException();
                    }
                    catch (KeeperException.NoNodeException e2) {
                        throw new ConcurrentModificationException();
                    }
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("zookeeper contained " + zPath + " " + (data == null ? null : new String(data, Charsets.UTF_8))));
                    }
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("putting " + zPath + " " + (data == null ? null : new String(data, Charsets.UTF_8)) + " in cache"));
                }
                ZooCache.this.put(zPath, data, stat);
            }
        };
        this.retry(zr);
        if (stat != null && (cstat = this.statCache.get(zPath)) != null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(baos);
                cstat.write((DataOutput)dos);
                dos.close();
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                DataInputStream dis = new DataInputStream(bais);
                stat.readFields((DataInput)dis);
                dis.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.cache.get(zPath);
    }

    private synchronized void put(String zPath, byte[] data, Stat stat) {
        this.cache.put(zPath, data);
        this.statCache.put(zPath, stat);
    }

    private synchronized void remove(String zPath) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("removing " + zPath + " from cache"));
        }
        this.cache.remove(zPath);
        this.childrenCache.remove(zPath);
        this.statCache.remove(zPath);
    }

    public synchronized void clear() {
        this.cache.clear();
        this.childrenCache.clear();
        this.statCache.clear();
    }

    @VisibleForTesting
    synchronized boolean dataCached(String zPath) {
        return this.cache.containsKey(zPath);
    }

    @VisibleForTesting
    synchronized boolean childrenCached(String zPath) {
        return this.childrenCache.containsKey(zPath);
    }

    public synchronized void clear(String zPath) {
        String path;
        Iterator<String> i = this.cache.keySet().iterator();
        while (i.hasNext()) {
            path = i.next();
            if (!path.startsWith(zPath)) continue;
            i.remove();
        }
        i = this.childrenCache.keySet().iterator();
        while (i.hasNext()) {
            path = i.next();
            if (!path.startsWith(zPath)) continue;
            i.remove();
        }
        i = this.statCache.keySet().iterator();
        while (i.hasNext()) {
            path = i.next();
            if (!path.startsWith(zPath)) continue;
            i.remove();
        }
    }

    @Deprecated
    public static synchronized ZooCache getInstance(String zooKeepers, int sessionTimeout) {
        return zcf.getZooCache(zooKeepers, sessionTimeout);
    }

    private static interface ZooRunnable {
        public void run(ZooKeeper var1) throws KeeperException, InterruptedException;
    }

    private class ZCacheWatcher
    implements Watcher {
        private ZCacheWatcher() {
        }

        public void process(WatchedEvent event) {
            if (log.isTraceEnabled()) {
                log.trace((Object)event);
            }
            block0 : switch (event.getType()) {
                case NodeDataChanged: 
                case NodeChildrenChanged: 
                case NodeCreated: 
                case NodeDeleted: {
                    ZooCache.this.remove(event.getPath());
                    break;
                }
                case None: {
                    switch (event.getState()) {
                        case Disconnected: {
                            if (log.isTraceEnabled()) {
                                log.trace((Object)"Zoo keeper connection disconnected, clearing cache");
                            }
                            ZooCache.this.clear();
                            break block0;
                        }
                        case SyncConnected: {
                            break block0;
                        }
                        case Expired: {
                            if (log.isTraceEnabled()) {
                                log.trace((Object)"Zoo keeper connection expired, clearing cache");
                            }
                            ZooCache.this.clear();
                            break block0;
                        }
                    }
                    log.warn((Object)("Unhandled: " + event));
                    break;
                }
                default: {
                    log.warn((Object)("Unhandled: " + event));
                }
            }
            if (ZooCache.this.externalWatcher != null) {
                ZooCache.this.externalWatcher.process(event);
            }
        }
    }
}

