/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.fate.zookeeper;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.SecurityPermission;
import java.util.List;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooReader;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public class ZooReaderWriter
extends ZooReader
implements IZooReaderWriter {
    private static SecurityPermission ZOOWRITER_PERMISSION = new SecurityPermission("zookeeperWriterPermission");
    private static ZooReaderWriter instance = null;
    private static IZooReaderWriter retryingInstance = null;
    private final String scheme;
    private final byte[] auth;

    @Override
    public ZooKeeper getZooKeeper() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ZOOWRITER_PERMISSION);
        }
        return this.getSession(this.keepers, this.timeout, this.scheme, this.auth);
    }

    public ZooReaderWriter(String string, int timeInMillis, String scheme, byte[] auth) {
        super(string, timeInMillis);
        this.scheme = scheme;
        this.auth = auth;
    }

    @Override
    public void recursiveDelete(String zPath, ZooUtil.NodeMissingPolicy policy) throws KeeperException, InterruptedException {
        ZooUtil.recursiveDelete(this.getZooKeeper(), zPath, policy);
    }

    @Override
    public void recursiveDelete(String zPath, int version, ZooUtil.NodeMissingPolicy policy) throws KeeperException, InterruptedException {
        ZooUtil.recursiveDelete(this.getZooKeeper(), zPath, version, policy);
    }

    @Override
    public boolean putPersistentData(String zPath, byte[] data, ZooUtil.NodeExistsPolicy policy) throws KeeperException, InterruptedException {
        return ZooUtil.putPersistentData(this.getZooKeeper(), zPath, data, policy);
    }

    @Override
    public boolean putPrivatePersistentData(String zPath, byte[] data, ZooUtil.NodeExistsPolicy policy) throws KeeperException, InterruptedException {
        return ZooUtil.putPrivatePersistentData(this.getZooKeeper(), zPath, data, policy);
    }

    @Override
    public void putPersistentData(String zPath, byte[] data, int version, ZooUtil.NodeExistsPolicy policy) throws KeeperException, InterruptedException {
        ZooUtil.putPersistentData(this.getZooKeeper(), zPath, data, version, policy);
    }

    @Override
    public String putPersistentSequential(String zPath, byte[] data) throws KeeperException, InterruptedException {
        return ZooUtil.putPersistentSequential(this.getZooKeeper(), zPath, data);
    }

    @Override
    public String putEphemeralData(String zPath, byte[] data) throws KeeperException, InterruptedException {
        return ZooUtil.putEphemeralData(this.getZooKeeper(), zPath, data);
    }

    @Override
    public String putEphemeralSequential(String zPath, byte[] data) throws KeeperException, InterruptedException {
        return ZooUtil.putEphemeralSequential(this.getZooKeeper(), zPath, data);
    }

    @Override
    public void recursiveCopyPersistent(String source, String destination, ZooUtil.NodeExistsPolicy policy) throws KeeperException, InterruptedException {
        ZooUtil.recursiveCopyPersistent(this.getZooKeeper(), source, destination, policy);
    }

    @Override
    public void delete(String path, int version) throws InterruptedException, KeeperException {
        this.getZooKeeper().delete(path, version);
    }

    @Override
    public byte[] mutate(String zPath, byte[] createValue, List<ACL> acl, Mutator mutator) throws Exception {
        if (createValue != null) {
            try {
                this.getZooKeeper().create(zPath, createValue, acl, CreateMode.PERSISTENT);
                return createValue;
            }
            catch (KeeperException.NodeExistsException ex) {
                // empty catch block
            }
        }
        while (true) {
            Stat stat = new Stat();
            byte[] data = this.getZooKeeper().getData(zPath, false, stat);
            if ((data = mutator.mutate(data)) == null) {
                return data;
            }
            try {
                this.getZooKeeper().setData(zPath, data, stat.getVersion());
                return data;
            }
            catch (KeeperException.BadVersionException ex) {
                continue;
            }
            break;
        }
    }

    public static synchronized ZooReaderWriter getInstance(String zookeepers, int timeInMillis, String scheme, byte[] auth) {
        if (instance == null) {
            instance = new ZooReaderWriter(zookeepers, timeInMillis, scheme, auth);
        }
        return instance;
    }

    public static synchronized IZooReaderWriter getRetryingInstance(String zookeepers, int timeInMillis, String scheme, byte[] auth) {
        if (retryingInstance == null) {
            final ZooReaderWriter inst = ZooReaderWriter.getInstance(zookeepers, timeInMillis, scheme, auth);
            InvocationHandler ih = new InvocationHandler(){

                @Override
                public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
                    long retryTime = 250L;
                    while (true) {
                        try {
                            return method.invoke((Object)inst, args);
                        }
                        catch (InvocationTargetException e) {
                            if (e.getCause() instanceof KeeperException.ConnectionLossException) {
                                Logger.getLogger(ZooReaderWriter.class).warn((Object)("Error connecting to zookeeper, will retry in " + String.format("%.2f secs", (double)retryTime / 1000.0)), e.getCause());
                                UtilWaitThread.sleep(retryTime);
                                retryTime = Math.min(5000L, retryTime + 250L);
                                continue;
                            }
                            throw e.getCause();
                        }
                        break;
                    }
                }
            };
            retryingInstance = (IZooReaderWriter)Proxy.newProxyInstance(ZooReaderWriter.class.getClassLoader(), new Class[]{IZooReaderWriter.class}, ih);
        }
        return retryingInstance;
    }

    @Override
    public boolean isLockHeld(ZooUtil.LockID lockID) throws KeeperException, InterruptedException {
        return ZooUtil.isLockHeld(this.getZooKeeper(), lockID);
    }

    @Override
    public void mkdirs(String path) throws KeeperException, InterruptedException {
        if (path.equals("")) {
            return;
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException(path + "does not start with /");
        }
        if (this.getZooKeeper().exists(path, false) != null) {
            return;
        }
        String parent = path.substring(0, path.lastIndexOf("/"));
        this.mkdirs(parent);
        this.putPersistentData(path, new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
    }

    public static interface Mutator {
        public byte[] mutate(byte[] var1) throws Exception;
    }
}

