/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.fate.zookeeper;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.commons.lang.NotImplementedException;
import org.apache.log4j.Logger;

public class DistributedReadWriteLock
implements ReadWriteLock {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    public static final Logger log = Logger.getLogger(DistributedReadWriteLock.class);
    private QueueLock qlock;
    private byte[] data;

    public DistributedReadWriteLock(QueueLock qlock, byte[] data) {
        this.qlock = qlock;
        this.data = Arrays.copyOf(data, data.length);
    }

    public static Lock recoverLock(QueueLock qlock, byte[] data) {
        SortedMap<Long, byte[]> entries = qlock.getEarlierEntries(Long.MAX_VALUE);
        for (Map.Entry<Long, byte[]> entry : entries.entrySet()) {
            ParsedLock parsed = new ParsedLock(entry.getValue());
            if (!Arrays.equals(data, parsed.getUserData())) continue;
            switch (parsed.getType()) {
                case READ: {
                    return new ReadLock(qlock, parsed.getUserData(), entry.getKey());
                }
                case WRITE: {
                    return new WriteLock(qlock, parsed.getUserData(), entry.getKey());
                }
            }
        }
        return null;
    }

    @Override
    public Lock readLock() {
        return new ReadLock(this.qlock, this.data);
    }

    @Override
    public Lock writeLock() {
        return new WriteLock(this.qlock, this.data);
    }

    static class WriteLock
    extends ReadLock {
        WriteLock(QueueLock qlock, byte[] userData) {
            super(qlock, userData);
        }

        WriteLock(QueueLock qlock, byte[] userData, long entry) {
            super(qlock, userData, entry);
        }

        @Override
        protected LockType lockType() {
            return LockType.WRITE;
        }

        @Override
        public boolean tryLock() {
            SortedMap<Long, byte[]> entries;
            Iterator<Map.Entry<Long, byte[]>> iterator;
            if (this.entry == -1L) {
                this.entry = this.qlock.addEntry(new ParsedLock(this.lockType(), this.userData).getLockData());
                log.info((Object)("Added lock entry " + this.entry + " userData " + new String(this.userData, UTF8) + " lockType " + (Object)((Object)this.lockType())));
            }
            if (!(iterator = (entries = this.qlock.getEarlierEntries(this.entry)).entrySet().iterator()).hasNext()) {
                throw new IllegalStateException("Did not find our own lock in the queue: " + this.entry + " userData " + new String(this.userData, UTF8) + " lockType " + (Object)((Object)this.lockType()));
            }
            return iterator.next().getKey().equals(this.entry);
        }
    }

    static class ReadLock
    implements Lock {
        QueueLock qlock;
        byte[] userData;
        long entry = -1L;
        long lastRead = -1L;

        ReadLock(QueueLock qlock, byte[] userData) {
            this.qlock = qlock;
            this.userData = userData;
        }

        ReadLock(QueueLock qlock, byte[] userData, long entry) {
            this.qlock = qlock;
            this.userData = userData;
            this.entry = entry;
        }

        protected LockType lockType() {
            return LockType.READ;
        }

        @Override
        public void lock() {
            while (true) {
                try {
                    while (!this.tryLock(1L, TimeUnit.DAYS)) {
                    }
                    return;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            while (!Thread.currentThread().isInterrupted()) {
                if (!this.tryLock(100L, TimeUnit.MILLISECONDS)) continue;
                return;
            }
        }

        @Override
        public boolean tryLock() {
            if (this.entry == -1L) {
                this.entry = this.qlock.addEntry(new ParsedLock(this.lockType(), this.userData).getLockData());
                log.info((Object)("Added lock entry " + this.entry + " userData " + new String(this.userData, UTF8) + " lockType " + (Object)((Object)this.lockType())));
            }
            SortedMap<Long, byte[]> entries = this.qlock.getEarlierEntries(this.entry);
            for (Map.Entry<Long, byte[]> entry : entries.entrySet()) {
                ParsedLock parsed = new ParsedLock(entry.getValue());
                if (entry.getKey().equals(this.entry)) {
                    return true;
                }
                if (parsed.type != LockType.WRITE) continue;
                return false;
            }
            throw new IllegalStateException("Did not find our own lock in the queue: " + this.entry + " userData " + new String(this.userData, UTF8) + " lockType " + (Object)((Object)this.lockType()));
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            long now = System.currentTimeMillis();
            long returnTime = now + TimeUnit.MILLISECONDS.convert(time, unit);
            while (returnTime > now) {
                if (this.tryLock()) {
                    return true;
                }
                UtilWaitThread.sleep(100L);
                now = System.currentTimeMillis();
            }
            return false;
        }

        @Override
        public void unlock() {
            if (this.entry == -1L) {
                return;
            }
            log.debug((Object)("Removing lock entry " + this.entry + " userData " + new String(this.userData, UTF8) + " lockType " + (Object)((Object)this.lockType())));
            this.qlock.removeEntry(this.entry);
            this.entry = -1L;
        }

        @Override
        public Condition newCondition() {
            throw new NotImplementedException();
        }
    }

    public static interface QueueLock {
        public SortedMap<Long, byte[]> getEarlierEntries(long var1);

        public void removeEntry(long var1);

        public long addEntry(byte[] var1);
    }

    static class ParsedLock {
        private LockType type;
        private byte[] userData;

        public ParsedLock(LockType type, byte[] userData) {
            this.type = type;
            this.userData = Arrays.copyOf(userData, userData.length);
        }

        public ParsedLock(byte[] lockData) {
            if (lockData == null || lockData.length < 1) {
                throw new IllegalArgumentException();
            }
            int split = -1;
            for (int i = 0; i < lockData.length; ++i) {
                if (lockData[i] != 58) continue;
                split = i;
                break;
            }
            if (split == -1) {
                throw new IllegalArgumentException();
            }
            this.type = LockType.valueOf(new String(lockData, 0, split, UTF8));
            this.userData = Arrays.copyOfRange(lockData, split + 1, lockData.length);
        }

        public LockType getType() {
            return this.type;
        }

        public byte[] getUserData() {
            return this.userData;
        }

        public byte[] getLockData() {
            byte[] typeBytes = this.type.name().getBytes(UTF8);
            byte[] result = new byte[this.userData.length + 1 + typeBytes.length];
            System.arraycopy(typeBytes, 0, result, 0, typeBytes.length);
            result[typeBytes.length] = 58;
            System.arraycopy(this.userData, 0, result, typeBytes.length + 1, this.userData.length);
            return result;
        }
    }

    static enum LockType {
        READ,
        WRITE;

    }
}

