/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.client.cache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.abdera.Abdera;
import org.apache.abdera.protocol.client.ClientResponse;
import org.apache.abdera.protocol.client.cache.Cache;
import org.apache.abdera.protocol.client.cache.CachedResponse;
import org.apache.abdera.protocol.client.cache.CachedResponseBase;
import org.apache.abdera.protocol.client.util.MethodHelper;
import org.apache.abdera.protocol.util.AbstractResponse;
import org.apache.abdera.protocol.util.CacheControlUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryCachedResponse
extends CachedResponseBase
implements CachedResponse {
    private final String method;
    private final int status;
    private final String status_text;
    private final String uri;
    private final Map<String, Object[]> headers;
    private final byte[] buf;

    public InMemoryCachedResponse(Abdera abdera, Cache cache, Object key, ClientResponse response) throws IOException {
        super(abdera, key, cache);
        this.method = response.getMethod();
        this.status = response.getStatus();
        this.status_text = response.getStatusText();
        this.uri = response.getUri();
        this.headers = MethodHelper.getCacheableHeaders(response);
        CacheControlUtil.parseCacheControl((String)this.getHeader("Cache-Control"), (AbstractResponse)this);
        this.buf = this.cacheStream(response.getInputStream());
        response.setInputStream(this.getInputStream());
    }

    private byte[] cacheStream(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        byte[] buf = new byte[1024];
        int m = -1;
        while ((m = in.read(buf)) != -1) {
            out.write(buf, 0, m);
        }
        return out.toByteArray();
    }

    public Map<String, Object[]> getHeaders() {
        return this.headers;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    public String getHeader(String header) {
        Object[] values = this.getHeaders().get(header);
        return values != null && values.length > 0 ? (String)values[0] : null;
    }

    public String[] getHeaderNames() {
        return this.getHeaders().keySet().toArray(new String[this.getHeaders().size()]);
    }

    public Object[] getHeaders(String header) {
        return this.getHeaders().get(header);
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusText() {
        return this.status_text;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.buf);
    }

    @Override
    public void setInputStream(InputStream in) {
        throw new UnsupportedOperationException();
    }
}

