/*
 * Decompiled with CFR 0.152.
 */
package org.apacheextras.camel.component.wmq;

import com.ibm.mq.MQMessage;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQTopic;
import java.util.GregorianCalendar;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.support.DefaultProducer;
import org.apacheextras.camel.component.wmq.WMQComponent;
import org.apacheextras.camel.component.wmq.WMQEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WMQProducer
extends DefaultProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(WMQProducer.class);
    private final WMQEndpoint endpoint;
    private MQQueueManager mqQueueManager;

    public WMQProducer(WMQEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public WMQEndpoint getEndpoint() {
        return (WMQEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        WMQComponent component = (WMQComponent)this.getEndpoint().getComponent();
        if (this.mqQueueManager == null) {
            this.mqQueueManager = component.getQueueManager(this.getEndpoint().getQueueManagerName(), this.getEndpoint().getQueueManagerHostname(), this.getEndpoint().getQueueManagerPort(), this.getEndpoint().getQueueManagerChannel(), this.getEndpoint().getQueueManagerUserID(), this.getEndpoint().getQueueManagerPassword(), this.getEndpoint().getQueueManagerCCSID());
        }
        Message in = exchange.getIn();
        LOGGER.debug("Accessing to MQQueue {}", (Object)this.endpoint.getDestinationName());
        int MQOO = 16;
        if (in.getHeader("MQOO") != null) {
            LOGGER.debug("MQOO defined to {}", in.getHeader("MQOO"));
            MQOO = (Integer)in.getHeader("MQOO");
        }
        try (MQTopic destination = null;){
            String destinationName;
            if (this.getEndpoint().getDestinationName().startsWith("topic:")) {
                destinationName = this.getEndpoint().getDestinationName().substring("topic:".length());
                destination = this.mqQueueManager.accessTopic(destinationName, null, MQOO, null, null);
            } else {
                destinationName = this.getEndpoint().getDestinationName();
                if (destinationName.startsWith("queue:")) {
                    destinationName = destinationName.substring("queue:".length());
                }
                destination = this.mqQueueManager.accessQueue(destinationName, MQOO, null, null, null);
            }
            LOGGER.info("Creating MQMessage");
            MQMessage message = new MQMessage();
            LOGGER.info("Populating MQMD headers");
            if (in.getHeader("mq.mqmd.format") != null) {
                message.format = (String)in.getHeader("mq.mqmd.format");
            }
            if (in.getHeader("mq.mqmd.charset") != null) {
                message.characterSet = (Integer)in.getHeader("mq.mqmd.charset");
            }
            if (in.getHeader("mq.mqmd.expiry") != null) {
                message.expiry = (Integer)in.getHeader("mq.mqmd.expiry");
            }
            if (in.getHeader("mq.mqmd.put.appl.name") != null) {
                message.putApplicationName = (String)in.getHeader("mq.mqmd.put.appl.name");
            }
            if (in.getHeader("mq.mqmd.group.id") != null) {
                message.groupId = (byte[])in.getHeader("mq.mqmd.group.id");
            }
            if (in.getHeader("mq.mqmd.msg.seq.number") != null) {
                message.messageSequenceNumber = (Integer)in.getHeader("mq.mqmd.msg.seq.number");
            }
            if (in.getHeader("mq.mqmd.msg.accounting.token") != null) {
                message.accountingToken = (byte[])in.getHeader("mq.mqmd.msg.accounting.token");
            }
            if (in.getHeader("mq.mqmd.correl.id") != null) {
                message.correlationId = (byte[])in.getHeader("mq.mqmd.correl.id");
            }
            if (in.getHeader("mq.mqmd.replyto.q") != null) {
                message.replyToQueueName = (String)in.getHeader("mq.mqmd.replyto.q");
            }
            if (in.getHeader("mq.mqmd.replyto.q.mgr") != null) {
                message.replyToQueueManagerName = (String)in.getHeader("mq.mqmd.replyto.q.mgr");
            }
            if (in.getHeader("mq.mqmd.putdatetime") != null) {
                message.putDateTime = (GregorianCalendar)in.getHeader("mq.mqmd.putdatetime");
            }
            if (in.getHeader("mq.mqmd.user.id") != null) {
                message.userId = (String)in.getHeader("mq.mqmd.user.id");
            }
            if (in.getHeader("mq.mqmd.type") != null) {
                message.messageType = (Integer)in.getHeader("mq.mqmd.type");
            }
            if (in.getHeader("mq.mqmd.priority") != null) {
                message.priority = (Integer)in.getHeader("mq.mqmd.priority");
            }
            if (in.getHeader("mq.mqmd.persistence") != null) {
                message.persistence = (Integer)in.getHeader("mq.mqmd.persistence");
            }
            if (in.getHeader("mq.mqmd.backout.count") != null) {
                message.backoutCount = (Integer)in.getHeader("mq.mqmd.backout.count");
            }
            if (in.getHeader("mq.mqmd.report") != null) {
                message.report = (Integer)in.getHeader("mq.mqmd.report");
            }
            if (in.getHeader("mq.mqmd.feedback") != null) {
                message.feedback = (Integer)in.getHeader("mq.mqmd.feedback");
            }
            if (in.getHeader("mq.mqmd.original.length") != null) {
                message.originalLength = (Integer)in.getHeader("mq.mqmd.original.length");
            }
            if (in.getHeader("mq.mqmd.appl.type") != null) {
                message.putApplicationType = (Integer)in.getHeader("mq.mqmd.appl.type");
            }
            if (in.getHeader("mq.mqmd.appl.id.data") != null) {
                message.applicationIdData = (String)in.getHeader("mq.mqmd.appl.id.data");
            }
            if (in.getHeader("mq.mqmd.appl.origin.data") != null) {
                message.applicationOriginData = (String)in.getHeader("mq.mqmd.appl.origin.data");
            }
            if (in.getHeader("mq.mqmd.id") != null) {
                message.messageId = (byte[])in.getHeader("mq.mqmd.id");
            }
            if (in.getHeader("mq.mqmd.offset") != null) {
                message.offset = (Integer)in.getHeader("mq.mqmd.offset");
            }
            if (in.getHeader("mq.mqmd.flags") != null) {
                message.messageFlags = (Integer)in.getHeader("mq.mqmd.flags");
            }
            if (in.getHeader("mq.mqmd.encoding") != null) {
                message.encoding = (Integer)in.getHeader("mq.mqmd.encoding");
            }
            boolean rfh2 = false;
            if (in.getHeaders().containsKey("mq.rfh2.format")) {
                LOGGER.info("mq.rfh2.format");
                message.format = "MQHRF2  ";
                rfh2 = true;
            }
            if (in.getHeader("mq.rfh2.struct.id") != null && rfh2) {
                LOGGER.info("mq.rfh2.struct.id defined: {}", in.getHeader("mq.rfh2.struct.id"));
                message.writeString((String)in.getHeader("mq.rfh2.struct.id"));
            } else if (rfh2) {
                LOGGER.info("mq.rfh2.struct.id not defined, fallback: {}", (Object)"RFH ");
                message.writeString("RFH ");
            }
            if (in.getHeader("mq.rfh2.version") != null && rfh2) {
                LOGGER.info("mq.rfh2.version defined: {}", in.getHeader("mq.rfh2.version"));
                message.writeInt4(((Integer)in.getHeader("mq.rfh2.version")).intValue());
            } else if (rfh2) {
                LOGGER.info("mq.rfh2.version not defined, fallback: {}", (Object)2);
                message.writeInt4(2);
            }
            LOGGER.info("Dealing with RFH2 folders");
            String mcd = (String)in.getHeader("mq.rfh2.folder.mcd");
            String jms = (String)in.getHeader("mq.rfh2.folder.jms");
            String usr = (String)in.getHeader("mq.rfh2.folder.usr");
            String pub = (String)in.getHeader("mq.rfh2.folder.psc");
            String pscr = (String)in.getHeader("mq.rfh2.folder.pscr");
            String other = (String)in.getHeader("mq.rfh2.folder.other");
            if (mcd != null) {
                LOGGER.debug("MCD V2 FOLDER: {}", (Object)mcd);
                while (mcd.length() % 4 != 0) {
                    mcd = mcd + " ";
                }
            }
            if (jms != null) {
                LOGGER.debug("JMS V2 FOLDER: {}", (Object)jms);
                while (jms.length() % 4 != 0) {
                    jms = jms + " ";
                }
            }
            if (usr != null) {
                LOGGER.debug("USR V2 FOLDER: {}", (Object)usr);
                while (usr.length() % 4 != 0) {
                    usr = usr + " ";
                }
            }
            if (pub != null) {
                LOGGER.debug("PUB V2 FOLDER: {}", (Object)pub);
                while (pub.length() % 4 != 0) {
                    pub = pub + " ";
                }
            }
            if (pscr != null) {
                LOGGER.debug("PSCR V2 FOLDER: {}", (Object)pscr);
                while (pscr.length() % 4 != 0) {
                    pscr = pscr + " ";
                }
            }
            if (other != null) {
                LOGGER.debug("OTHER V2 FOLDER: {}", (Object)other);
                while (other.length() % 4 != 0) {
                    other = other + " ";
                }
            }
            int folderSize = 0;
            int overhead = 0;
            if (mcd != null) {
                folderSize += mcd.length();
                overhead += 4;
            }
            if (jms != null) {
                folderSize += jms.length();
                overhead += 4;
            }
            if (usr != null) {
                folderSize += usr.length();
                overhead += 4;
            }
            if (pub != null) {
                folderSize += pub.length();
                overhead += 4;
            }
            if (pscr != null) {
                folderSize += pscr.length();
                overhead += 4;
            }
            if (other != null) {
                folderSize += other.length();
                overhead += 4;
            }
            if (rfh2) {
                LOGGER.debug("Set message length: {}", (Object)(36 + folderSize + overhead));
                message.writeInt4(36 + folderSize + overhead);
            }
            if (in.getHeader("mq.rfh2.encoding") != null && rfh2) {
                LOGGER.debug("mq.rfh2.encoding defined: {}", in.getHeader("mq.rfh2.encoding"));
                message.writeInt4(((Integer)in.getHeader("mq.rfh2.encoding")).intValue());
            } else if (rfh2) {
                LOGGER.debug("mq.rfh2.encoding not defined, fallback: {}", (Object)273);
                message.writeInt4(273);
            }
            if (in.getHeader("mq.rfh2.coded.charset.id") != null && rfh2) {
                LOGGER.debug("mq.rfh2.coded.charset.id defined: {}", in.getHeader("mq.rfh2.coded.charset.id"));
                message.writeInt4(((Integer)in.getHeader("mq.rfh2.coded.charset.id")).intValue());
            } else if (rfh2) {
                LOGGER.debug("mq.rfh2.coded.charset.id not defined, fallback: {}", (Object)0);
                message.writeInt4(0);
            }
            if (rfh2) {
                message.writeString("        ");
                message.writeInt4(0);
                message.writeInt4(1208);
            }
            if (mcd != null) {
                message.writeInt4(mcd.length());
                message.writeString(mcd);
            }
            if (jms != null) {
                message.writeInt4(jms.length());
                message.writeString(jms);
            }
            if (usr != null) {
                message.writeInt4(usr.length());
                message.writeString(usr);
            }
            if (pub != null) {
                message.writeInt4(pub.length());
                message.writeString(pub);
            }
            if (pscr != null) {
                message.writeInt4(pscr.length());
                message.writeString(pscr);
            }
            if (other != null) {
                message.writeInt4(other.length());
                message.writeString(other);
            }
            message.writeString((String)in.getBody(String.class));
            LOGGER.debug("Putting the message ...");
            destination.put(message);
        }
    }
}

