/*
 * Decompiled with CFR 0.152.
 */
package org.apacheextras.camel.component.wmq;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apacheextras.camel.component.wmq.WMQComponent;
import org.apacheextras.camel.component.wmq.WMQConsumer;
import org.apacheextras.camel.component.wmq.WMQProducer;

@UriEndpoint(firstVersion="2.25.3", scheme="wmq", title="IBM WebSphere MQ", syntax="wmq:destinationName", category={Category.JAVA})
public class WMQEndpoint
extends DefaultEndpoint {
    @UriPath
    @Metadata(required=true, description="MQ destination name")
    private String destinationName;
    @UriParam
    @Metadata(description="Queue manager name")
    private String queueManagerName;
    @UriParam
    @Metadata(description="Queue manager hostname")
    private String queueManagerHostname;
    @UriParam
    @Metadata(description="Queue manager port number")
    private String queueManagerPort;
    @UriParam
    @Metadata(description="Queue manager channel name")
    private String queueManagerChannel;
    @UriParam
    @Metadata(description="Queue manager user ID")
    private String queueManagerUserID;
    @UriParam
    @Metadata(description="Queue manager password")
    private String queueManagerPassword;
    @UriParam
    @Metadata(description="Queue manager CCSID")
    private String queueManagerCCSID;
    @UriParam
    @Metadata(description="Type of the message body")
    private String bodyType;
    @UriParam
    @Metadata(description="Polling delay (iteration)")
    private int delay = 5;
    @UriParam
    @Metadata(description="Timeout/delay when exception occur")
    private int delayOnException = 60000;

    public WMQEndpoint() {
    }

    public WMQEndpoint(String uri, WMQComponent component) {
        super(uri, (Component)component);
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public String getQueueManagerName() {
        return this.queueManagerName;
    }

    public void setQueueManagerName(String queueManagerName) {
        this.queueManagerName = queueManagerName;
    }

    public String getQueueManagerHostname() {
        return this.queueManagerHostname;
    }

    public void setQueueManagerHostname(String queueManagerHostname) {
        this.queueManagerHostname = queueManagerHostname;
    }

    public String getQueueManagerPort() {
        return this.queueManagerPort;
    }

    public void setQueueManagerPort(String queueManagerPort) {
        this.queueManagerPort = queueManagerPort;
    }

    public String getQueueManagerChannel() {
        return this.queueManagerChannel;
    }

    public void setQueueManagerChannel(String queueManagerChannel) {
        this.queueManagerChannel = queueManagerChannel;
    }

    public String getQueueManagerUserID() {
        return this.queueManagerUserID;
    }

    public void setQueueManagerUserID(String queueManagerUserID) {
        this.queueManagerUserID = queueManagerUserID;
    }

    public String getQueueManagerPassword() {
        return this.queueManagerPassword;
    }

    public void setQueueManagerPassword(String queueManagerPassword) {
        this.queueManagerPassword = queueManagerPassword;
    }

    public String getQueueManagerCCSID() {
        return this.queueManagerCCSID;
    }

    public void setQueueManagerCCSID(String queueManagerCCSID) {
        this.queueManagerCCSID = queueManagerCCSID;
    }

    public void setBodyType(String bodyType) {
        this.bodyType = bodyType;
    }

    public String getBodyType() {
        return this.bodyType;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public int getDelayOnException() {
        return this.delayOnException;
    }

    public void setDelayOnException(int delayOnException) {
        this.delayOnException = delayOnException;
    }

    public Producer createProducer() throws Exception {
        return new WMQProducer(this);
    }

    public WMQConsumer createConsumer(Processor processor) throws Exception {
        WMQConsumer consumer = new WMQConsumer(this, processor);
        consumer.setDelay(this.delay);
        return consumer;
    }

    @ManagedAttribute
    public boolean isSingleton() {
        return true;
    }
}

