/*
 * Decompiled with CFR 0.152.
 */
package org.apacheextras.camel.component.wmq;

import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.headers.MQDataException;
import com.ibm.mq.headers.MQHeaderList;
import com.ibm.mq.headers.MQRFH2;
import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Function;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.SuspendableService;
import org.apache.camel.support.ScheduledPollConsumer;
import org.apacheextras.camel.component.wmq.WMQComponent;
import org.apacheextras.camel.component.wmq.WMQEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WMQConsumer
extends ScheduledPollConsumer
implements SuspendableService {
    private static final Logger LOGGER = LoggerFactory.getLogger(WMQConsumer.class);
    private final Function<MQMessage, MQHeaderList> mqHeaderListFactory;
    private MQQueueManager mqQueueManager = null;

    public WMQConsumer(WMQEndpoint endpoint, Processor processor) {
        this(endpoint, processor, WMQConsumer::createMqHeaderList);
    }

    public WMQConsumer(WMQEndpoint endpoint, Processor processor, Function<MQMessage, MQHeaderList> mqHeaderListFactory) {
        super((Endpoint)endpoint, processor);
        this.mqHeaderListFactory = mqHeaderListFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int poll() throws Exception {
        Exchange exchange = this.getEndpoint().createExchange();
        Message in = exchange.getIn();
        WMQComponent component = (WMQComponent)this.getEndpoint().getComponent();
        if (this.mqQueueManager == null) {
            this.mqQueueManager = component.getQueueManager(this.getEndpoint().getQueueManagerName(), this.getEndpoint().getQueueManagerHostname(), this.getEndpoint().getQueueManagerPort(), this.getEndpoint().getQueueManagerChannel(), this.getEndpoint().getQueueManagerUserID(), this.getEndpoint().getQueueManagerPassword(), this.getEndpoint().getQueueManagerCCSID());
        }
        try (MQQueue destination = null;){
            String destinationName;
            LOGGER.debug("Consuming from {}", (Object)this.getEndpoint().getDestinationName());
            if (this.getEndpoint().getDestinationName().startsWith("topic:")) {
                destinationName = this.getEndpoint().getDestinationName().substring("topic:".length());
                int options = 8206;
                destination = this.mqQueueManager.accessTopic(destinationName, null, options, null, null);
            } else {
                destinationName = this.getEndpoint().getDestinationName();
                if (destinationName.startsWith("queue:")) {
                    destinationName = destinationName.substring("queue:".length());
                }
                destination = this.mqQueueManager.accessQueue(destinationName, 1, null, null, null);
            }
            MQMessage message = new MQMessage();
            MQGetMessageOptions options = new MQGetMessageOptions();
            options.options = 0x10070001;
            options.waitInterval = -1;
            LOGGER.info("Waiting for message ...");
            destination.get(message, options);
            LOGGER.info("Message consumed");
            LOGGER.info("Dealing with MQMD headers");
            LOGGER.info("\tmq.mqmd.format: {}", (Object)message.format);
            in.setHeader("mq.mqmd.format", (Object)message.format);
            LOGGER.info("\tmq.mqmd.charset: {}", (Object)message.characterSet);
            in.setHeader("mq.mqmd.charset", (Object)message.characterSet);
            LOGGER.info("\tmq.mqmd.expiry: {}", (Object)message.expiry);
            in.setHeader("mq.mqmd.expiry", (Object)message.expiry);
            LOGGER.info("\tmq.mqmd.put.appl.name: {}", (Object)message.putApplicationName);
            in.setHeader("mq.mqmd.put.appl.name", (Object)message.putApplicationName);
            LOGGER.info("\tmq.mqmd.group.id: {}", (Object)message.groupId);
            in.setHeader("mq.mqmd.group.id", (Object)message.groupId);
            LOGGER.info("\tmq.mqmd.msg.seq.number: {}", (Object)message.messageSequenceNumber);
            in.setHeader("mq.mqmd.msg.seq.number", (Object)message.messageSequenceNumber);
            LOGGER.info("\tmq.mqmd.msg.accounting.token: {}", (Object)message.accountingToken);
            in.setHeader("mq.mqmd.msg.accounting.token", (Object)message.accountingToken);
            LOGGER.info("\tmq.mqmd.correl.id: {}", (Object)message.correlationId);
            in.setHeader("mq.mqmd.correl.id", (Object)message.correlationId);
            LOGGER.info("\tmq.mqmd.replyto.q: {}", (Object)message.replyToQueueName);
            in.setHeader("mq.mqmd.replyto.q", (Object)message.replyToQueueName);
            LOGGER.info("\tmq.mqmd.replyto.q.mgr: {}", (Object)message.replyToQueueManagerName);
            in.setHeader("mq.mqmd.replyto.q.mgr", (Object)message.replyToQueueManagerName);
            LOGGER.info("\tmq.mqmd.putdatetime: {}", (Object)message.putDateTime);
            in.setHeader("mq.mqmd.putdatetime", (Object)message.putDateTime);
            LOGGER.info("\tmq.mqmd.user.id: {}", (Object)message.userId);
            in.setHeader("mq.mqmd.user.id", (Object)message.userId);
            LOGGER.info("\tmq.mqmd.type", (Object)message.messageType);
            in.setHeader("mq.mqmd.type", (Object)message.messageType);
            LOGGER.info("\tmq.mqmd.priority", (Object)message.priority);
            in.setHeader("mq.mqmd.priority", (Object)message.priority);
            LOGGER.info("\tmq.mqmd.persistence", (Object)message.persistence);
            in.setHeader("mq.mqmd.persistence", (Object)message.persistence);
            LOGGER.info("\tmq.mqmd.backout.count", (Object)message.backoutCount);
            in.setHeader("mq.mqmd.backout.count", (Object)message.backoutCount);
            LOGGER.info("\tmq.mqmd.report", (Object)message.report);
            in.setHeader("mq.mqmd.report", (Object)message.report);
            LOGGER.info("\tmq.mqmd.feedback", (Object)message.feedback);
            in.setHeader("mq.mqmd.feedback", (Object)message.feedback);
            LOGGER.info("\tmq.mqmd.original.length", (Object)message.originalLength);
            in.setHeader("mq.mqmd.original.length", (Object)message.originalLength);
            LOGGER.info("\tmq.mqmd.appl.type", (Object)message.putApplicationType);
            in.setHeader("mq.mqmd.appl.type", (Object)message.putApplicationType);
            LOGGER.info("\tmq.mqmd.appl.id.data", (Object)message.applicationIdData);
            in.setHeader("mq.mqmd.appl.id.data", (Object)message.applicationIdData);
            LOGGER.info("\tmq.mqmd.appl.origin.data", (Object)message.applicationOriginData);
            in.setHeader("mq.mqmd.appl.origin.data", (Object)message.applicationOriginData);
            LOGGER.info("\tmq.mqmd.id", (Object)message.messageId);
            in.setHeader("mq.mqmd.id", (Object)message.messageId);
            LOGGER.info("\tmq.mqmd.offset", (Object)message.offset);
            in.setHeader("mq.mqmd.offset", (Object)message.offset);
            LOGGER.info("\tmq.mqmd.flags", (Object)message.messageFlags);
            in.setHeader("mq.mqmd.flags", (Object)message.messageFlags);
            LOGGER.info("\tmq.mqmd.length.total", (Object)message.getTotalMessageLength());
            in.setHeader("mq.mqmd.length.total", (Object)message.getTotalMessageLength());
            LOGGER.info("\tmq.mqmd.length.data", (Object)message.getDataLength());
            in.setHeader("mq.mqmd.length.data", (Object)message.getDataLength());
            LOGGER.info("\tmq.mqmd.encoding", (Object)message.encoding);
            in.setHeader("mq.mqmd.encoding", (Object)message.encoding);
            MQHeaderList headerList = this.mqHeaderListFactory.apply(message);
            int index = headerList.indexOf("MQRFH2");
            if (index >= 0) {
                MQRFH2.Element[] folders;
                LOGGER.info("MQRFH2 header detected (index " + index + ")");
                MQRFH2 rfh = (MQRFH2)headerList.get(index);
                LOGGER.info("\tmq.rfh2.format: " + rfh.getFormat());
                in.setHeader("mq.rfh2.format", (Object)rfh.getFormat());
                LOGGER.info("\tmq.rfh2.struct.id: " + rfh.getStrucId());
                in.setHeader("mq.rfh2.struct.id", (Object)rfh.getStrucId());
                LOGGER.info("\tmq.rfh2.encoding: " + rfh.getEncoding());
                in.setHeader("mq.rfh2.encoding", (Object)rfh.getEncoding());
                LOGGER.info("\tmq.rfh2.coded.charset.id: " + rfh.getCodedCharSetId());
                in.setHeader("mq.rfh2.coded.charset.id", (Object)rfh.getCodedCharSetId());
                LOGGER.info("\tmq.rfh2.flags: " + rfh.getFlags());
                in.setHeader("mq.rfh2.flags", (Object)rfh.getFlags());
                LOGGER.info("\tmq.rfh2.version: " + rfh.getVersion());
                in.setHeader("mq.rfh2.version", (Object)rfh.getVersion());
                for (MQRFH2.Element folder : folders = rfh.getFolders()) {
                    LOGGER.info("mq.rfh2.folder " + folder.getName() + ": " + folder.toXML());
                    in.setHeader("mq.rfh2.folder." + folder.getName(), (Object)folder.toXML());
                }
            }
            LOGGER.info("Reading body");
            byte[] buffer = new byte[message.getDataLength()];
            message.readFully(buffer);
            this.saveBody(in, buffer);
            this.getProcessor().process(exchange);
        }
        if (exchange.getException() != null) {
            this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
        }
        return 1;
    }

    private void saveBody(Message in, byte[] buffer) throws Exception {
        if ("bytes".equals(this.getEndpoint().getBodyType())) {
            in.setBody((Object)ByteBuffer.wrap(buffer), ByteBuffer.class);
        } else {
            String body = this.getEndpoint().getBodyType() != null ? new String(buffer, this.getEndpoint().getBodyType()) : new String(buffer);
            in.setBody((Object)body, String.class);
        }
    }

    public WMQEndpoint getEndpoint() {
        return (WMQEndpoint)super.getEndpoint();
    }

    private static MQHeaderList createMqHeaderList(MQMessage mqMessage) {
        try {
            return new MQHeaderList((DataInput)mqMessage);
        }
        catch (MQDataException | IOException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodError e) {
            throw new IllegalStateException("This error can happen when a specific IBM class is not on the classpath (com.ibm.mq.headers.internal.MQMessageWrapper). If you don't add it, constructor throws NoSucheMethodError. Message found : " + e.getMessage(), e);
        }
    }
}

