/*
 * Decompiled with CFR 0.152.
 */
package org.apacheextras.camel.component.wmq;

import org.apache.camel.Component;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apacheextras.camel.component.wmq.WMQConsumer;
import org.apacheextras.camel.component.wmq.WMQProducer;

@ManagedResource(description="Managed WMQ Endpoint")
@UriEndpoint(scheme="wmq", title="IBM WebSphere MQ", syntax="wmq:destinationName", consumerClass=WMQConsumer.class)
public class WMQEndpoint
extends DefaultEndpoint {
    @UriParam
    private String destinationName;
    @UriParam
    private String queueManagerName;
    @UriParam
    private String queueManagerHostname;
    @UriParam
    private String queueManagerPort;
    @UriParam
    private String queueManagerChannel;
    @UriParam
    private String queueManagerUserID;
    @UriParam
    private String queueManagerPassword;
    @UriParam
    private String queueManagerCCSID;
    @UriParam
    private String bodyType;
    @UriParam
    private int delay = 5;
    @UriParam
    private int delayOnException = 60000;

    public WMQEndpoint() {
    }

    public WMQEndpoint(String uri, Component component, String destinationName) {
        super(uri, component);
        this.destinationName = destinationName;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public String getQueueManagerName() {
        return this.queueManagerName;
    }

    public void setQueueManagerName(String queueManagerName) {
        this.queueManagerName = queueManagerName;
    }

    public String getQueueManagerHostname() {
        return this.queueManagerHostname;
    }

    public void setQueueManagerHostname(String queueManagerHostname) {
        this.queueManagerHostname = queueManagerHostname;
    }

    public String getQueueManagerPort() {
        return this.queueManagerPort;
    }

    public void setQueueManagerPort(String queueManagerPort) {
        this.queueManagerPort = queueManagerPort;
    }

    public String getQueueManagerChannel() {
        return this.queueManagerChannel;
    }

    public void setQueueManagerChannel(String queueManagerChannel) {
        this.queueManagerChannel = queueManagerChannel;
    }

    public String getQueueManagerUserID() {
        return this.queueManagerUserID;
    }

    public void setQueueManagerUserID(String queueManagerUserID) {
        this.queueManagerUserID = queueManagerUserID;
    }

    public String getQueueManagerPassword() {
        return this.queueManagerPassword;
    }

    public void setQueueManagerPassword(String queueManagerPassword) {
        this.queueManagerPassword = queueManagerPassword;
    }

    public String getQueueManagerCCSID() {
        return this.queueManagerCCSID;
    }

    public void setQueueManagerCCSID(String queueManagerCCSID) {
        this.queueManagerCCSID = queueManagerCCSID;
    }

    public void setBodyType(String bodyType) {
        this.bodyType = bodyType;
    }

    public String getBodyType() {
        return this.bodyType;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public int getDelayOnException() {
        return this.delayOnException;
    }

    public void setDelayOnException(int delayOnException) {
        this.delayOnException = delayOnException;
    }

    public Producer createProducer() throws Exception {
        return new WMQProducer(this);
    }

    public WMQConsumer createConsumer(Processor processor) throws Exception {
        WMQConsumer consumer = new WMQConsumer(this, processor);
        consumer.setDelay(this.delay);
        return consumer;
    }

    @ManagedAttribute
    public boolean isSingleton() {
        return true;
    }
}

