/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.codegen;

import org.antlr.v4.Tool;
import org.antlr.v4.codegen.CodeGenerator;
import org.antlr.v4.codegen.model.RuleFunction;
import org.antlr.v4.misc.Utils;
import org.antlr.v4.runtime.RuntimeMetaData;
import org.antlr.v4.tool.ErrorType;
import org.antlr.v4.tool.Grammar;
import org.antlr.v4.tool.Rule;
import org.antlr.v4.tool.ast.GrammarAST;
import org.stringtemplate.v4.NumberRenderer;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STErrorListener;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;
import org.stringtemplate.v4.StringRenderer;
import org.stringtemplate.v4.misc.STMessage;

public abstract class Target {
    protected String[] targetCharValueEscape = new String[255];
    private final CodeGenerator gen;
    private final String language;
    private STGroup templates;

    protected Target(CodeGenerator gen, String language) {
        this.targetCharValueEscape[10] = "\\n";
        this.targetCharValueEscape[13] = "\\r";
        this.targetCharValueEscape[9] = "\\t";
        this.targetCharValueEscape[8] = "\\b";
        this.targetCharValueEscape[12] = "\\f";
        this.targetCharValueEscape[92] = "\\\\";
        this.targetCharValueEscape[39] = "\\'";
        this.targetCharValueEscape[34] = "\\\"";
        this.gen = gen;
        this.language = language;
    }

    public CodeGenerator getCodeGenerator() {
        return this.gen;
    }

    public String getLanguage() {
        return this.language;
    }

    public abstract String getVersion();

    public STGroup getTemplates() {
        if (this.templates == null) {
            String version = this.getVersion();
            if (version == null || !RuntimeMetaData.getMajorMinorVersion(version).equals(RuntimeMetaData.getMajorMinorVersion(Tool.VERSION))) {
                this.gen.tool.errMgr.toolError(ErrorType.INCOMPATIBLE_TOOL_AND_TEMPLATES, version, Tool.VERSION, this.language);
            }
            this.templates = this.loadTemplates();
        }
        return this.templates;
    }

    protected void genFile(Grammar g, ST outputFileST, String fileName) {
        this.getCodeGenerator().write(outputFileST, fileName);
    }

    protected void genListenerFile(Grammar g, ST outputFileST) {
        String fileName = this.getCodeGenerator().getListenerFileName();
        this.getCodeGenerator().write(outputFileST, fileName);
    }

    protected void genRecognizerHeaderFile(Grammar g, ST headerFileST, String extName) {
    }

    public String getTokenTypeAsTargetLabel(Grammar g, int ttype) {
        String name = g.getTokenName(ttype);
        if ("<INVALID>".equals(name)) {
            return String.valueOf(ttype);
        }
        return name;
    }

    public String[] getTokenTypesAsTargetLabels(Grammar g, int[] ttypes) {
        String[] labels = new String[ttypes.length];
        for (int i = 0; i < ttypes.length; ++i) {
            labels[i] = this.getTokenTypeAsTargetLabel(g, ttypes[i]);
        }
        return labels;
    }

    public String getTargetStringLiteralFromString(String s, boolean quoted) {
        if (s == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        if (quoted) {
            buf.append('\"');
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '\'' && c < this.targetCharValueEscape.length && this.targetCharValueEscape[c] != null) {
                buf.append(this.targetCharValueEscape[c]);
                continue;
            }
            buf.append(c);
        }
        if (quoted) {
            buf.append('\"');
        }
        return buf.toString();
    }

    public String getTargetStringLiteralFromString(String s) {
        return this.getTargetStringLiteralFromString(s, true);
    }

    public String getTargetStringLiteralFromANTLRStringLiteral(CodeGenerator generator, String literal, boolean addQuotes) {
        StringBuilder sb = new StringBuilder();
        String is = literal;
        if (addQuotes) {
            sb.append('\"');
        }
        for (int i = 1; i < is.length() - 1; ++i) {
            if (is.charAt(i) == '\\') {
                switch (is.charAt(i + 1)) {
                    case '\"': 
                    case '\\': 
                    case 'b': 
                    case 'f': 
                    case 'n': 
                    case 'r': 
                    case 't': {
                        sb.append('\\');
                        break;
                    }
                    case 'u': {
                        sb.append('\\');
                        sb.append('\\');
                        break;
                    }
                }
                ++i;
            } else if (is.charAt(i) == '\"') {
                sb.append('\\');
            }
            sb.append(is.charAt(i));
        }
        if (addQuotes) {
            sb.append('\"');
        }
        return sb.toString();
    }

    public String encodeIntAsCharEscape(int v) {
        if (v < 0 || v > 65535) {
            throw new IllegalArgumentException(String.format("Cannot encode the specified value: %d", v));
        }
        if (v >= 0 && v < this.targetCharValueEscape.length && this.targetCharValueEscape[v] != null) {
            return this.targetCharValueEscape[v];
        }
        if (!(v < 32 || v >= 127 || Character.isDigit(v) && v != 56 && v != 57)) {
            return String.valueOf((char)v);
        }
        if (v >= 0 && v <= 127) {
            String oct = Integer.toOctalString(v);
            return "\\" + oct;
        }
        String hex = Integer.toHexString(v | 0x10000).substring(1, 5);
        return "\\u" + hex;
    }

    public String getLoopLabel(GrammarAST ast) {
        return "loop" + ast.token.getTokenIndex();
    }

    public String getLoopCounter(GrammarAST ast) {
        return "cnt" + ast.token.getTokenIndex();
    }

    public String getListLabel(String label) {
        ST st = this.getTemplates().getInstanceOf("ListLabelName");
        st.add("label", label);
        return st.render();
    }

    public String getRuleFunctionContextStructName(Rule r) {
        if (r.g.isLexer()) {
            return this.getTemplates().getInstanceOf("LexerRuleContext").render();
        }
        return Utils.capitalize(r.name) + this.getTemplates().getInstanceOf("RuleContextNameSuffix").render();
    }

    public String getAltLabelContextStructName(String label) {
        return Utils.capitalize(label) + this.getTemplates().getInstanceOf("RuleContextNameSuffix").render();
    }

    public String getRuleFunctionContextStructName(RuleFunction function) {
        Rule r = function.rule;
        if (r.g.isLexer()) {
            return this.getTemplates().getInstanceOf("LexerRuleContext").render();
        }
        return Utils.capitalize(r.name) + this.getTemplates().getInstanceOf("RuleContextNameSuffix").render();
    }

    public String getImplicitTokenLabel(String tokenName) {
        ST st = this.getTemplates().getInstanceOf("ImplicitTokenLabel");
        int ttype = this.getCodeGenerator().g.getTokenType(tokenName);
        if (tokenName.startsWith("'")) {
            return "s" + ttype;
        }
        String text = this.getTokenTypeAsTargetLabel(this.getCodeGenerator().g, ttype);
        st.add("tokenName", text);
        return st.render();
    }

    public String getImplicitSetLabel(String id) {
        ST st = this.getTemplates().getInstanceOf("ImplicitSetLabel");
        st.add("id", id);
        return st.render();
    }

    public String getImplicitRuleLabel(String ruleName) {
        ST st = this.getTemplates().getInstanceOf("ImplicitRuleLabel");
        st.add("ruleName", ruleName);
        return st.render();
    }

    public String getElementListName(String name) {
        ST st = this.getTemplates().getInstanceOf("ElementListName");
        st.add("elemName", this.getElementName(name));
        return st.render();
    }

    public String getElementName(String name) {
        if (".".equals(name)) {
            return "_wild";
        }
        if (this.getCodeGenerator().g.getRule(name) != null) {
            return name;
        }
        int ttype = this.getCodeGenerator().g.getTokenType(name);
        if (ttype == 0) {
            return name;
        }
        return this.getTokenTypeAsTargetLabel(this.getCodeGenerator().g, ttype);
    }

    public int getSerializedATNSegmentLimit() {
        return Integer.MAX_VALUE;
    }

    public int getInlineTestSetWordSize() {
        return 64;
    }

    public boolean grammarSymbolCausesIssueInGeneratedCode(GrammarAST idNode) {
        switch (idNode.getParent().getType()) {
            case 10: {
                switch (idNode.getParent().getParent().getType()) {
                    case 42: 
                    case 81: {
                        return false;
                    }
                }
                break;
            }
            case 11: 
            case 81: {
                return false;
            }
            case 85: {
                if (idNode.getChildIndex() != 0) break;
                return false;
            }
        }
        return this.visibleGrammarSymbolCausesIssueInGeneratedCode(idNode);
    }

    protected abstract boolean visibleGrammarSymbolCausesIssueInGeneratedCode(GrammarAST var1);

    public boolean templatesExist() {
        String groupFileName = "org/antlr/v4/tool/templates/codegen/" + this.getLanguage() + "/" + this.getLanguage() + STGroup.GROUP_FILE_EXTENSION;
        STGroupFile result = null;
        try {
            result = new STGroupFile(groupFileName);
        }
        catch (IllegalArgumentException iae) {
            result = null;
        }
        return result != null;
    }

    protected STGroup loadTemplates() {
        String groupFileName = "org/antlr/v4/tool/templates/codegen/" + this.getLanguage() + "/" + this.getLanguage() + STGroup.GROUP_FILE_EXTENSION;
        STGroupFile result = null;
        try {
            result = new STGroupFile(groupFileName);
        }
        catch (IllegalArgumentException iae) {
            this.gen.tool.errMgr.toolError(ErrorType.MISSING_CODE_GEN_TEMPLATES, iae, this.language);
        }
        if (result == null) {
            return null;
        }
        result.registerRenderer(Integer.class, new NumberRenderer());
        result.registerRenderer(String.class, new StringRenderer());
        result.setListener(new STErrorListener(){

            @Override
            public void compileTimeError(STMessage msg) {
                this.reportError(msg);
            }

            @Override
            public void runTimeError(STMessage msg) {
                this.reportError(msg);
            }

            @Override
            public void IOError(STMessage msg) {
                this.reportError(msg);
            }

            @Override
            public void internalError(STMessage msg) {
                this.reportError(msg);
            }

            private void reportError(STMessage msg) {
                Target.this.getCodeGenerator().tool.errMgr.toolError(ErrorType.STRING_TEMPLATE_WARNING, msg.cause, msg.toString());
            }
        });
        return result;
    }

    public boolean wantsBaseListener() {
        return true;
    }

    public boolean wantsBaseVisitor() {
        return true;
    }

    public boolean supportsOverloadedMethods() {
        return true;
    }
}

