/*
 * Decompiled with CFR 0.152.
 */
package alluxio.time;

public class ExponentialTimer {
    private final long mMaxIntervalMs;
    private final long mLastEventHorizonMs;
    private long mNumEvents;
    private long mNextEventMs;
    private long mIntervalMs;

    public ExponentialTimer(long initialIntervalMs, long maxIntervalMs, long initialWaitTimeMs, long maxTotalWaitTimeMs) {
        this.mMaxIntervalMs = maxIntervalMs;
        this.mLastEventHorizonMs = System.currentTimeMillis() + maxTotalWaitTimeMs;
        this.mNextEventMs = System.currentTimeMillis() + initialWaitTimeMs;
        this.mIntervalMs = Math.min(initialIntervalMs, maxIntervalMs);
        this.mNumEvents = 0L;
    }

    public long getNumEvents() {
        return this.mNumEvents;
    }

    public Result tick() {
        if (System.currentTimeMillis() >= this.mLastEventHorizonMs) {
            return Result.EXPIRED;
        }
        if (System.currentTimeMillis() < this.mNextEventMs) {
            return Result.NOT_READY;
        }
        this.mNextEventMs = System.currentTimeMillis() + this.mIntervalMs;
        long next = Math.min(this.mIntervalMs * 2L, this.mMaxIntervalMs);
        if (next < this.mIntervalMs) {
            next = Integer.MAX_VALUE;
        }
        this.mIntervalMs = next;
        ++this.mNumEvents;
        return Result.READY;
    }

    public static enum Result {
        EXPIRED,
        NOT_READY,
        READY;

    }
}

