/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication;

import alluxio.shaded.client.io.grpc.CallOptions;
import alluxio.shaded.client.io.grpc.Channel;
import alluxio.shaded.client.io.grpc.ClientCall;
import alluxio.shaded.client.io.grpc.ClientInterceptor;
import alluxio.shaded.client.io.grpc.ForwardingClientCall;
import alluxio.shaded.client.io.grpc.ForwardingClientCallListener;
import alluxio.shaded.client.io.grpc.Metadata;
import alluxio.shaded.client.io.grpc.MethodDescriptor;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.util.UUID;

@ThreadSafe
public final class ChannelIdInjector
implements ClientInterceptor {
    public static final Metadata.Key<UUID> S_CLIENT_ID_KEY = Metadata.Key.of("channel-id", new Metadata.AsciiMarshaller<UUID>(){

        @Override
        public String toAsciiString(UUID value) {
            return value.toString();
        }

        @Override
        public UUID parseAsciiString(String serialized) {
            return UUID.fromString(serialized);
        }
    });
    private final UUID mChannelId;

    public ChannelIdInjector(UUID channelId) {
        this.mChannelId = channelId;
    }

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            @Override
            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                headers.put(S_CLIENT_ID_KEY, ChannelIdInjector.this.mChannelId);
                super.start(new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    @Override
                    public void onHeaders(Metadata headers) {
                        super.onHeaders(headers);
                    }
                }, headers);
            }
        };
    }
}

