/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.security.authentication.AuthType;
import alluxio.security.authentication.plain.CustomAuthenticationProvider;
import alluxio.security.authentication.plain.SimpleAuthenticationProvider;
import javax.security.sasl.AuthenticationException;

public interface AuthenticationProvider {
    public void authenticate(String var1, String var2) throws AuthenticationException;

    public static class Factory {
        private Factory() {
        }

        public static AuthenticationProvider create(AuthType authType, AlluxioConfiguration conf) throws AuthenticationException {
            switch (authType) {
                case SIMPLE: {
                    return new SimpleAuthenticationProvider();
                }
                case CUSTOM: {
                    Class customProviderName = conf.getClass(PropertyKey.SECURITY_AUTHENTICATION_CUSTOM_PROVIDER_CLASS);
                    return new CustomAuthenticationProvider(customProviderName);
                }
            }
            throw new AuthenticationException("Unsupported AuthType: " + (Object)((Object)authType));
        }
    }
}

